/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombieawareness.client;

import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SoundRegistry {
    private static HashMap<String, SoundEvent> lookupStringToEvent = new HashMap();

    public static void init() {
        SoundRegistry.register("alert");
        SoundRegistry.register("target");
        SoundRegistry.register("investigate");
    }

    public static void register(String soundPath) {
        ResourceLocation resLoc = new ResourceLocation("zombieawareness", soundPath);
        SoundEvent event = (SoundEvent)new SoundEvent(resLoc).setRegistryName(resLoc);
        if (lookupStringToEvent.containsKey(soundPath)) {
            System.out.println("ZA SOUNDS WARNING: duplicate sound registration for " + soundPath);
        } else {
            ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)event);
            lookupStringToEvent.put(soundPath, event);
        }
    }

    public static SoundEvent get(String soundPath) {
        return lookupStringToEvent.get(soundPath);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onSoundsRegistry(RegistryEvent.Register<SoundEvent> event) {
            SoundRegistry.init();
        }
    }
}

