/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.coroutil.util;

import com.corosus.coroutil.repack.de.androidpit.colorthief.ColorThief;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.state.BlockState;

public class CoroUtilColor {
    public static int[] getColors(BlockState state) {
        TextureAtlasSprite sprite;
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(state);
        if (model != null && !model.m_7521_() && (sprite = model.m_6160_()) != null && !sprite.m_118413_().equals((Object)MissingTextureAtlasSprite.m_118071_())) {
            return CoroUtilColor.getColors(sprite);
        }
        return IntArrays.EMPTY_ARRAY;
    }

    public static int[] getColors(TextureAtlasSprite sprite) {
        int width = sprite.m_118405_();
        int height = sprite.m_118408_();
        int frames = sprite.m_118415_();
        BufferedImage img = new BufferedImage(width, height * frames, 6);
        for (int i = 0; i < frames; ++i) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int abgr = sprite.getPixelRGBA(i, x, y);
                    int red = abgr & 0xFF;
                    int green = abgr >> 8 & 0xFF;
                    int blue = abgr >> 16 & 0xFF;
                    int alpha = abgr >> 24 & 0xFF;
                    img.setRGB(x, y + i * height, alpha << 24 | red << 16 | green << 8 | blue);
                }
            }
        }
        int[][] colorData = ColorThief.getPalette(img, 6, 5, true);
        if (colorData != null) {
            int[] ret = new int[colorData.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = CoroUtilColor.getColor(colorData[i]);
            }
            return ret;
        }
        return IntArrays.EMPTY_ARRAY;
    }

    private static int getColor(int[] colorData) {
        float mr = 1.0f;
        float mg = 1.0f;
        float mb = 1.0f;
        return 0xFF000000 | (int)((float)colorData[0] * mr) << 16 | (int)((float)colorData[1] * mg) << 8 | (int)((float)colorData[2] * mb);
    }
}

