/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client;

import chylex.bettersprinting.BetterSprintingMod;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class ClientModManager {
    public static KeyBinding keyBindSprint = new KeyBinding("Sprint (hold)", 29, "key.categories.movement");
    public static KeyBinding keyBindSprintToggle = new KeyBinding("Sprint (toggle)", 34, "key.categories.movement");
    public static KeyBinding keyBindSneakToggle = new KeyBinding("Sneak (toggle)", 21, "key.categories.movement");
    public static KeyBinding keyBindSprintMenu = new KeyBinding("Sprint menu", 24, "key.categories.movement");
    public static int flyingBoost = 3;
    public static boolean allowDoubleTap = false;
    public static boolean allowAllDirs = false;
    public static boolean disableModFunctionality = false;
    public static boolean showedToggleSneakWarning = false;
    public static boolean enableUpdateNotifications = true;
    public static boolean svFlyingBoost = false;
    public static boolean svRunInAllDirs = false;
    public static boolean fromBs = false;
    public static boolean held = false;
    public static int stoptime = 0;

    public static boolean canRunInAllDirs(Minecraft mc) {
        return disableModFunctionality ? false : mc.field_71439_g == null && mc.field_71441_e == null || mc.func_71356_B() || svRunInAllDirs;
    }

    public static boolean canBoostFlying(Minecraft mc) {
        return disableModFunctionality ? false : mc.field_71439_g == null && mc.field_71441_e == null || mc.func_71356_B() || mc.field_71439_g.field_71075_bZ.field_75098_d || svFlyingBoost;
    }

    private static int nbtInt(NBTTagCompound tag, String key, int def) {
        return tag.func_74764_b(key) ? tag.func_74762_e(key) : def;
    }

    private static boolean nbtBool(NBTTagCompound tag, String key, boolean def) {
        return tag.func_74764_b(key) ? tag.func_74767_n(key) : def;
    }

    public static void loadSprint(Minecraft mc) {
        File file = new File(mc.field_71412_D, "sprint.nbt");
        if (!file.exists()) {
            return;
        }
        try {
            NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file)).func_74775_l("Data");
            if (tag == null) {
                return;
            }
            keyBindSprintMenu.func_151462_b(ClientModManager.nbtInt(tag, "keyMenu", 24));
            keyBindSprint.func_151462_b(ClientModManager.nbtInt(tag, "keySprint", 29));
            keyBindSprintToggle.func_151462_b(ClientModManager.nbtInt(tag, "keySprintToggle", 34));
            keyBindSneakToggle.func_151462_b(ClientModManager.nbtInt(tag, "keySneakToggle", 21));
            flyingBoost = ClientModManager.nbtInt(tag, "flyBoost", 3);
            allowDoubleTap = ClientModManager.nbtBool(tag, "doubleTap", false);
            allowAllDirs = ClientModManager.nbtBool(tag, "allDirs", false);
            disableModFunctionality = ClientModManager.nbtBool(tag, "disableMod", false);
            showedToggleSneakWarning = ClientModManager.nbtBool(tag, "showedWarn", false);
            enableUpdateNotifications = ClientModManager.nbtBool(tag, "updateNotifications", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            BetterSprintingMod.logger.error("Error loading Better Sprinting settings!");
        }
    }

    public static void saveSprint(Minecraft mc) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("keyMenu", keyBindSprintMenu.func_151463_i());
        tag.func_74768_a("keySprint", keyBindSprint.func_151463_i());
        tag.func_74768_a("keySprintToggle", keyBindSprintToggle.func_151463_i());
        tag.func_74768_a("keySneakToggle", keyBindSneakToggle.func_151463_i());
        tag.func_74768_a("flyBoost", flyingBoost);
        tag.func_74757_a("doubleTap", allowDoubleTap);
        tag.func_74757_a("allDirs", allowAllDirs);
        tag.func_74757_a("disableMod", disableModFunctionality);
        tag.func_74757_a("showedWarn", showedToggleSneakWarning);
        tag.func_74757_a("updateNotifications", enableUpdateNotifications);
        NBTTagCompound fintag = new NBTTagCompound();
        fintag.func_74782_a("Data", (NBTBase)tag);
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)fintag, (OutputStream)new FileOutputStream(new File(mc.field_71412_D, "sprint.nbt")));
        }
        catch (Exception e) {
            e.printStackTrace();
            BetterSprintingMod.logger.error("Error saving Better Sprinting settings!");
        }
    }
}

