/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client.update;

import chylex.bettersprinting.BetterSprintingMod;
import chylex.bettersprinting.client.update.VersionEntry;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import cpw.mods.fml.relauncher.FMLInjectionData;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class UpdateThread
extends Thread {
    private final String modVersion;
    private final String mcVersion;

    public UpdateThread(String modVersion) {
        this.modVersion = modVersion;
        this.mcVersion = (String)FMLInjectionData.data()[4];
        this.setPriority(1);
    }

    @Override
    public void run() {
        try {
            StringBuilder message;
            String line;
            StringBuilder build = new StringBuilder();
            BufferedReader read = new BufferedReader(new InputStreamReader(new URL("https://dl.dropboxusercontent.com/u/17157118/update/bettersprinting.txt").openStream()));
            while ((line = read.readLine()) != null) {
                build.append(line).append("\n");
            }
            read.close();
            JsonElement root = new JsonParser().parse(build.toString());
            ArrayList<VersionEntry> versionList = new ArrayList<VersionEntry>();
            VersionEntry newestVersion = null;
            VersionEntry newestVersionForCurrentMC = null;
            int counter = -1;
            boolean isInDev = true;
            System.out.println("Detecting Better Sprinting updates...");
            for (Map.Entry entry : root.getAsJsonObject().entrySet()) {
                versionList.add(new VersionEntry((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject()));
            }
            Collections.sort(versionList);
            for (VersionEntry version : versionList) {
                System.out.println("Reading update data: " + version.versionIdentifier);
                if (newestVersion == null) {
                    newestVersion = version;
                }
                if (version.isSupportedByMC(this.mcVersion)) {
                    if (newestVersionForCurrentMC == null) {
                        newestVersionForCurrentMC = version;
                    }
                    ++counter;
                }
                if (!version.modVersion.equals(this.modVersion)) continue;
                isInDev = false;
                break;
            }
            if (isInDev) {
                System.out.println("In-dev version used, notifications disabled.");
                return;
            }
            System.out.println("Done.");
            if (counter > 0) {
                message = new StringBuilder().append(EnumChatFormatting.LIGHT_PURPLE).append(" [Better Sprinting ").append(this.modVersion).append("]").append(EnumChatFormatting.RESET).append("\n Found a new version ").append(EnumChatFormatting.GREEN).append(newestVersionForCurrentMC.modVersionName).append(EnumChatFormatting.RESET).append(" for Minecraft ").append(this.mcVersion).append(", released ").append(newestVersionForCurrentMC.releaseDate).append(". You are currently ").append(counter).append(" version").append(counter == 1 ? "" : "s").append(" behind.");
                if (newestVersion != newestVersionForCurrentMC) {
                    message.append("\n\n There is also an update ").append(EnumChatFormatting.GREEN).append(newestVersion.modVersion).append(EnumChatFormatting.RESET).append(" for Minecraft ").append(CommandBase.func_71527_a((Object[])newestVersion.mcVersions)).append(".");
                }
                message.append("\n\n ").append(EnumChatFormatting.GRAY).append("http://tinyurl.com/better-sprinting-mod");
                for (String s : message.toString().split("\n")) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(s));
                }
            } else if (newestVersion != newestVersionForCurrentMC) {
                message = new StringBuilder().append(EnumChatFormatting.LIGHT_PURPLE).append(" [Better Sprinting ").append(this.modVersion).append("]").append(EnumChatFormatting.RESET).append("\n Found a new version ").append(EnumChatFormatting.GREEN).append(newestVersion.modVersion).append(EnumChatFormatting.RESET).append(" for Minecraft ").append(CommandBase.func_71527_a((Object[])newestVersion.mcVersions)).append(", released ").append(newestVersion.releaseDate).append(".");
                for (String s : message.toString().split("\n")) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(s));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BetterSprintingMod.logger.error("Error detecting updates!");
        }
    }
}

