/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting;

import chylex.bettersprinting.BetterSprintingMod;
import java.io.File;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BetterSprintingConfig {
    private final Configuration config;
    private final boolean isNew;
    private String currentCategory = "unknown";

    BetterSprintingConfig(File file) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.isNew = !file.exists();
        this.config = new Configuration(file);
        this.reload();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.getModID().equals("bettersprinting")) {
            this.reload();
        }
    }

    private void reload() {
        BetterSprintingMod.proxy.loadSidedConfig(this);
    }

    public void update() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public boolean isNew() {
        return this.isNew;
    }

    public String getFileName() {
        return this.config.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public List<IConfigElement> getClientGuiElements(String category) {
        return new ConfigElement(this.config.getCategory(category)).getChildElements();
    }

    public void setCategory(String newCategory) {
        this.currentCategory = newCategory;
    }

    public Property get(String name, boolean defValue) {
        return this.config.get(this.currentCategory, name, defValue, "");
    }

    public Property get(String name, boolean defValue, String comment) {
        Property property = this.config.get(this.currentCategory, name, defValue, "");
        property.setComment(comment);
        return property;
    }

    public Property get(String name, int defValue) {
        return this.config.get(this.currentCategory, name, defValue, "");
    }

    public Property get(String name, String defValue) {
        return this.config.get(this.currentCategory, name, defValue, "");
    }

    public void set(String name, boolean value) {
        this.config.get(this.currentCategory, name, value).set(value);
    }

    public void set(String name, int value) {
        this.config.get(this.currentCategory, name, value).set(value);
    }

    public void set(String name, String value) {
        this.config.get(this.currentCategory, name, value).set(value);
    }
}

