/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client;

import chylex.bettersprinting.BetterSprintingConfig;
import chylex.bettersprinting.BetterSprintingMod;
import chylex.bettersprinting.client.input.KeyBindingInfo;
import chylex.bettersprinting.client.input.SprintKeyMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientSettings {
    public static int keyCodeSprintHold = 29;
    public static int keyCodeSprintToggle = 34;
    public static int keyCodeSneakToggle = 21;
    public static int keyCodeOptionsMenu = 24;
    public static KeyModifier keyModSprintHold = KeyModifier.NONE;
    public static KeyModifier keyModSprintToggle = KeyModifier.NONE;
    public static KeyModifier keyModSneakToggle = KeyModifier.NONE;
    public static KeyModifier keyModOptionsMenu = KeyModifier.NONE;
    public static KeyBindingInfo keyInfoSprintHold;
    public static KeyBindingInfo keyInfoSprintToggle;
    public static KeyBindingInfo keyInfoSneakToggle;
    public static KeyBindingInfo keyInfoOptionsMenu;
    public static SprintKeyMode sprintKeyMode;
    public static int flySpeedBoost;
    public static boolean flyOnGround;
    public static boolean enableDoubleTap;
    public static boolean enableAllDirs;
    public static boolean disableMod;
    public static boolean enableUpdateNotifications;
    public static boolean enableBuildCheck;

    public static void reload(BetterSprintingConfig config) {
        config.setCategory("client");
        keyCodeSprintHold = config.get("keySprintHold", keyCodeSprintHold).setShowInGui(false).getInt();
        keyCodeSprintToggle = config.get("keySprintToggle", keyCodeSprintToggle).setShowInGui(false).getInt();
        keyCodeSneakToggle = config.get("keySneakToggle", keyCodeSneakToggle).setShowInGui(false).getInt();
        keyCodeOptionsMenu = config.get("keyOptionsMenu", keyCodeOptionsMenu).setShowInGui(false).getInt();
        keyModSprintHold = KeyModifier.valueOf((String)config.get("keyModSprintHold", keyModSprintHold.name()).setShowInGui(false).getString());
        keyModSprintToggle = KeyModifier.valueOf((String)config.get("keyModSprintToggle", keyModSprintToggle.name()).setShowInGui(false).getString());
        keyModSneakToggle = KeyModifier.valueOf((String)config.get("keyModSneakToggle", keyModSneakToggle.name()).setShowInGui(false).getString());
        keyModOptionsMenu = KeyModifier.valueOf((String)config.get("keyModOptionsMenu", keyModOptionsMenu.name()).setShowInGui(false).getString());
        sprintKeyMode = SprintKeyMode.valueOf(config.get("sprintKeyMode", sprintKeyMode.name()).setShowInGui(false).getString());
        flySpeedBoost = MathHelper.func_76125_a((int)config.get("flySpeedBoost", flySpeedBoost).setShowInGui(false).getInt(), (int)0, (int)7);
        flyOnGround = config.get("flyOnGround", flyOnGround).setShowInGui(false).getBoolean();
        enableDoubleTap = config.get("enableDoubleTap", enableDoubleTap).setShowInGui(false).getBoolean();
        enableAllDirs = config.get("enableAllDirs", enableAllDirs).setShowInGui(false).getBoolean();
        disableMod = config.get("disableMod", disableMod).setShowInGui(false).getBoolean();
        enableUpdateNotifications = config.get("enableUpdateNotifications", enableUpdateNotifications, I18n.func_135052_a((String)"bs.config.notifications", (Object[])new Object[0])).getBoolean();
        enableBuildCheck = config.get("enableBuildCheck", enableBuildCheck, I18n.func_135052_a((String)"bs.config.buildCheck", (Object[])new Object[0])).getBoolean();
        keyInfoSprintHold = new KeyBindingInfo(v -> {
            keyCodeSprintHold = v;
        }, () -> keyCodeSprintHold, v -> {
            keyModSprintHold = v;
        }, () -> keyModSprintHold);
        keyInfoSprintToggle = new KeyBindingInfo(v -> {
            keyCodeSprintToggle = v;
        }, () -> keyCodeSprintToggle, v -> {
            keyModSprintToggle = v;
        }, () -> keyModSprintToggle);
        keyInfoSneakToggle = new KeyBindingInfo(v -> {
            keyCodeSneakToggle = v;
        }, () -> keyCodeSneakToggle, v -> {
            keyModSneakToggle = v;
        }, () -> keyModSneakToggle);
        keyInfoOptionsMenu = new KeyBindingInfo(v -> {
            keyCodeOptionsMenu = v;
        }, () -> keyCodeOptionsMenu, v -> {
            keyModOptionsMenu = v;
        }, () -> keyModOptionsMenu);
        config.update();
    }

    public static void update(BetterSprintingConfig config) {
        config.setCategory("client");
        config.set("keySprintHold", keyCodeSprintHold);
        config.set("keySprintToggle", keyCodeSprintToggle);
        config.set("keySneakToggle", keyCodeSneakToggle);
        config.set("keyOptionsMenu", keyCodeOptionsMenu);
        config.set("keyModSprintHold", keyModSprintHold.name());
        config.set("keyModSprintToggle", keyModSprintToggle.name());
        config.set("keyModSneakToggle", keyModSneakToggle.name());
        config.set("keyModOptionsMenu", keyModOptionsMenu.name());
        config.set("sprintKeyMode", sprintKeyMode.name());
        config.set("flySpeedBoost", flySpeedBoost);
        config.set("flyOnGround", flyOnGround);
        config.set("enableDoubleTap", enableDoubleTap);
        config.set("enableAllDirs", enableAllDirs);
        config.set("disableMod", disableMod);
        config.set("enableUpdateNotifications", enableUpdateNotifications);
        config.set("enableBuildCheck", enableBuildCheck);
        config.update();
    }

    public static void firstTimeSetup() {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        keyInfoSprintHold.readFrom(settings.field_151444_V);
        KeyModifier sprintModifier = ClientSettings.getVanillaKeyModifier(settings.field_151444_V);
        KeyModifier sneakModifier = ClientSettings.getVanillaKeyModifier(settings.field_74311_E);
        if (sprintModifier != KeyModifier.NONE) {
            keyInfoSprintToggle.set(sprintModifier, 34);
        }
        if (sneakModifier != KeyModifier.NONE) {
            keyInfoSneakToggle.set(sneakModifier, 34);
        }
        ClientSettings.update(BetterSprintingMod.config);
    }

    private static KeyModifier getVanillaKeyModifier(KeyBinding binding) {
        if (binding.getKeyModifier() != KeyModifier.NONE) {
            return KeyModifier.NONE;
        }
        switch (binding.func_151463_i()) {
            case 29: {
                return KeyModifier.CONTROL;
            }
            case 42: {
                return KeyModifier.SHIFT;
            }
            case 56: {
                return KeyModifier.ALT;
            }
        }
        return KeyModifier.NONE;
    }

    static {
        sprintKeyMode = SprintKeyMode.TAP;
        flySpeedBoost = 3;
        flyOnGround = false;
        enableDoubleTap = false;
        enableAllDirs = false;
        disableMod = false;
        enableUpdateNotifications = true;
        enableBuildCheck = true;
    }
}

