/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client.gui;

import chylex.bettersprinting.client.gui.GuiButtonCustomInput;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class GuiButtonInputBinding
extends GuiButtonCustomInput<GuiButtonInputBinding> {
    private static final GameSettings settings = Minecraft.func_71410_x().field_71474_y;
    public final KeyBinding binding;
    private boolean isSelected;

    public GuiButtonInputBinding(int id, int x, int y, KeyBinding binding, Consumer<GuiButtonInputBinding> onClick) {
        super(id, x, y, "", binding == GuiButtonInputBinding.settings.field_151444_V ? "bs.sprint.hold" : binding.func_151464_g(), onClick);
        this.binding = binding;
        this.updateKeyBindingText();
    }

    @Override
    protected GuiButtonInputBinding getContext() {
        return this;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
        this.updateKeyBindingText();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setBinding(int keyCode) {
        this.binding.setKeyModifierAndCode(KeyModifier.NONE, keyCode);
        this.isSelected = false;
    }

    public void setBinding(KeyModifier modifier, int keyCode) {
        this.binding.setKeyModifierAndCode(modifier, keyCode);
        this.isSelected &= KeyModifier.isKeyCodeModifier((int)keyCode) && modifier != KeyModifier.NONE;
    }

    public void updateKeyBindingText() {
        boolean hasConflict = false;
        boolean hasOnlyModifierConflict = true;
        if (this.binding.func_151463_i() != 0) {
            for (KeyBinding other : GuiButtonInputBinding.settings.field_74324_K) {
                if (this.binding == other || !this.binding.conflicts(other)) continue;
                hasConflict = true;
                hasOnlyModifierConflict &= this.binding.hasKeyCodeModifierConflict(other);
            }
        }
        if (this.isSelected) {
            this.setMessage(TextFormatting.WHITE + "> " + TextFormatting.YELLOW + this.binding.getDisplayName() + TextFormatting.WHITE + " <");
        } else if (hasConflict) {
            this.setMessage((hasOnlyModifierConflict ? TextFormatting.GOLD : TextFormatting.RED) + this.binding.getDisplayName());
        } else {
            this.setMessage(this.binding.getDisplayName());
        }
    }
}

