/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client.player;

import chylex.bettersprinting.client.ClientModManager;
import chylex.bettersprinting.client.ClientSettings;
import chylex.bettersprinting.client.input.SprintState;
import chylex.bettersprinting.client.player.MovementController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.init.MobEffects;
import net.minecraft.util.MovementInput;

final class PlayerLogicHandler {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private final EntityPlayerSP player;
    private final PlayerCapabilities abilities;
    private final MovementInput movementInput;
    private final MovementController movementController;
    private boolean wasMovingForward;
    private boolean wasSneaking;
    private SprintState sprinting;

    public PlayerLogicHandler(EntityPlayerSP player) {
        this.player = player;
        this.abilities = player.field_71075_bZ;
        this.movementInput = player.field_71158_b;
        this.movementController = new MovementController(this.movementInput);
        this.sprinting = player.func_70051_ag() ? SprintState.DOUBLE_TAPPED_FORWARD : SprintState.INACTIVE;
    }

    public EntityPlayerSP getPlayer() {
        return this.player;
    }

    public void updateMovementInput() {
        if (ClientModManager.Feature.FLY_ON_GROUND.isTriggered()) {
            this.player.field_70122_E = false;
        }
        this.wasSneaking = this.movementInput.field_78899_d;
        this.wasMovingForward = this.movementController.isMovingFastForward();
        this.movementController.update();
    }

    public void updateSprinting() {
        boolean shouldSprint;
        boolean isNotSneaking;
        boolean enoughHunger = (float)this.player.func_71024_bL().func_75116_a() > 6.0f || this.abilities.field_75101_c;
        boolean isSprintBlocked = this.player.func_184587_cr() || this.player.func_70644_a(MobEffects.field_76440_q);
        boolean isSprintHeld = ClientModManager.keyBindSprintHold.func_151470_d();
        boolean bl = isNotSneaking = !this.movementInput.field_78899_d || this.abilities.field_75100_b;
        if (ClientSettings.enableDoubleTap && this.player.field_70122_E && !this.wasSneaking && !this.wasMovingForward && this.movementController.isMovingFastForward() && !this.sprinting.active() && enoughHunger && !isSprintBlocked) {
            if (this.player.field_71156_d <= 0 && !isSprintHeld) {
                this.player.field_71156_d = 7;
            } else {
                this.sprinting = SprintState.DOUBLE_TAPPED_FORWARD;
            }
        }
        if (!this.sprinting.active() && this.movementController.isMovingFastForward() && enoughHunger && !isSprintBlocked && isSprintHeld) {
            this.sprinting = ClientSettings.sprintKeyMode.sprintState;
        }
        if (this.movementController.isSprintToggled()) {
            this.sprinting = SprintState.TOGGLED;
        } else if (this.sprinting == SprintState.TOGGLED) {
            this.sprinting = SprintState.INACTIVE;
        }
        if (isSprintHeld) {
            if (this.sprinting != SprintState.TAPPING_SPRINT_KEY && this.sprinting != SprintState.TOGGLED) {
                this.sprinting = SprintState.HOLDING_SPRINT_KEY;
            }
        } else if (this.sprinting == SprintState.TAPPING_SPRINT_KEY) {
            this.sprinting = SprintState.TAPPED_SPRINT_KEY;
        } else if (this.sprinting == SprintState.HOLDING_SPRINT_KEY) {
            this.sprinting = SprintState.INACTIVE;
        }
        if (this.sprinting.active()) {
            boolean stopRunning;
            boolean isSlow = ClientModManager.Feature.RUN_IN_ALL_DIRS.isTriggered() ? !this.movementController.isMovingAnywhere() : !this.movementController.isMovingFastForward();
            boolean isSlowOrHungry = isSlow || !enoughHunger;
            boolean bl2 = stopRunning = isSlowOrHungry || this.player.field_70123_F;
            if (stopRunning) {
                this.sprinting = SprintState.INACTIVE;
            }
        }
        boolean bl3 = shouldSprint = this.sprinting.active() && isNotSneaking && !isSprintBlocked;
        if (this.player.func_70051_ag() != shouldSprint) {
            this.player.func_70031_b(shouldSprint);
            if (!shouldSprint && this.sprinting == SprintState.TAPPED_SPRINT_KEY) {
                this.sprinting = SprintState.INACTIVE;
            }
        }
        float flySpeedBase = 0.05f;
        int flySpeedBoostMultiplier = ClientSettings.flySpeedBoost;
        if (flySpeedBoostMultiplier > 0) {
            if (ClientModManager.Feature.FLY_BOOST.isTriggered()) {
                this.abilities.func_75092_a(flySpeedBase + 0.075f * (float)flySpeedBoostMultiplier);
            } else {
                this.abilities.func_75092_a(flySpeedBase);
            }
        } else if (this.abilities.func_75093_a() > flySpeedBase) {
            this.abilities.func_75092_a(flySpeedBase);
        }
    }

    public void updateFlight() {
        if (this.player.field_70122_E && this.abilities.field_75100_b && !PlayerLogicHandler.mc.field_71442_b.func_178887_k() && !ClientModManager.Feature.FLY_ON_GROUND.isTriggered()) {
            this.abilities.field_75100_b = false;
            this.player.func_71016_p();
        }
    }
}

