/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.server;

import chylex.bettersprinting.BetterSprintingMod;
import chylex.bettersprinting.server.ServerNetwork;
import chylex.bettersprinting.server.ServerSettings;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public class ServerCommandConfig
extends CommandBase {
    public String func_71517_b() {
        return "bettersprinting";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/bettersprinting [...]";
    }

    public int func_82362_a() {
        return 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.sendMessage(sender, TextFormatting.GREEN + "[Better Sprinting]");
            this.sendMessage(sender, "/bettersprinting info");
            this.sendMessage(sender, "/bettersprinting disablemod <true|false>");
            this.sendMessage(sender, "/bettersprinting setting <survivalFlyBoost|runInAllDirs> <true|false>");
            return;
        } else if (args[0].equalsIgnoreCase("info")) {
            this.sendMessageTranslated(sender, "bs.command.info");
            return;
        } else if (args[0].equalsIgnoreCase("disablemod")) {
            if (!this.isValidBool(args, 1)) throw new WrongUsageException("commands.generic.syntax", new Object[0]);
            ServerSettings.disableClientMod = this.getBool(args, 1);
            ServerSettings.update(BetterSprintingMod.config);
            this.sendMessageTranslated(sender, ServerSettings.disableClientMod ? "bs.command.disableMod" : "bs.command.enableMod");
            ServerNetwork.sendToAll(server.func_184103_al().func_181057_v(), ServerNetwork.writeDisableMod(ServerSettings.disableClientMod));
            return;
        } else {
            if (!args[0].equalsIgnoreCase("setting")) throw new WrongUsageException("commands.generic.syntax", new Object[0]);
            if (args.length <= 1 || !this.isValidBool(args, 2)) {
                throw new WrongUsageException("commands.generic.syntax", new Object[0]);
            }
            if (args[1].equalsIgnoreCase("survivalFlyBoost")) {
                ServerSettings.enableSurvivalFlyBoost = this.getBool(args, 2);
                ServerSettings.update(BetterSprintingMod.config);
                this.sendMessageTranslated(sender, ServerSettings.enableSurvivalFlyBoost ? "bs.command.enableFlyBoost" : "bs.command.disableFlyBoost");
                ServerNetwork.sendToAll(server.func_184103_al().func_181057_v(), ServerNetwork.writeSettings(ServerSettings.enableSurvivalFlyBoost, ServerSettings.enableAllDirs));
                return;
            } else {
                if (!args[1].equalsIgnoreCase("runInAllDirs")) return;
                ServerSettings.enableAllDirs = this.getBool(args, 2);
                ServerSettings.update(BetterSprintingMod.config);
                this.sendMessageTranslated(sender, ServerSettings.enableAllDirs ? "bs.command.enableAllDirs" : "bs.command.disableAllDirs");
                ServerNetwork.sendToAll(server.func_184103_al().func_181057_v(), ServerNetwork.writeSettings(ServerSettings.enableSurvivalFlyBoost, ServerSettings.enableAllDirs));
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return ServerCommandConfig.func_71530_a((String[])args, (String[])new String[]{"info", "disablemod", "setting"});
        }
        if (args[0].equalsIgnoreCase("disablemod")) {
            if (args.length == 2) {
                return ServerCommandConfig.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
            }
        } else if (args[0].equalsIgnoreCase("setting")) {
            if (args.length == 2) {
                return ServerCommandConfig.func_71530_a((String[])args, (String[])new String[]{"survivalFlyBoost", "runInAllDirs"});
            }
            if (args.length == 3) {
                return ServerCommandConfig.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
            }
        }
        return Collections.emptyList();
    }

    private void sendMessage(ICommandSender sender, String text) {
        sender.func_145747_a((ITextComponent)new TextComponentString(text));
    }

    private void sendMessageTranslated(ICommandSender sender, String translationName) {
        if (sender instanceof EntityPlayer && ServerNetwork.hasBetterSprinting((EntityPlayer)sender)) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(translationName, new Object[0]));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)translationName)));
        }
    }

    private boolean isValidBool(String[] args, int index) {
        return index < args.length && (args[index].equalsIgnoreCase("true") || args[index].equalsIgnoreCase("false"));
    }

    private boolean getBool(String[] args, int index) {
        return args[index].equalsIgnoreCase("true");
    }
}

