/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.server;

import chylex.bettersprinting.server.ServerSettings;
import chylex.bettersprinting.system.PacketPipeline;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.SERVER)
final class ServerNetwork
implements PacketPipeline.INetworkHandler {
    private static final Set<UUID> players = Collections.synchronizedSet(new HashSet());

    ServerNetwork() {
    }

    public static boolean hasBetterSprinting(EntityPlayer player) {
        return players.contains(player.func_110124_au());
    }

    public static void onDisconnected(EntityPlayer player) {
        players.remove(player.func_110124_au());
    }

    public static PacketBuffer writeSettings(boolean enableSurvivalFlyBoost, boolean enableAllDirs) {
        PacketBuffer buffer = PacketPipeline.buf();
        buffer.writeByte(0).writeBoolean(enableSurvivalFlyBoost).writeBoolean(enableAllDirs);
        return buffer;
    }

    public static PacketBuffer writeDisableMod(boolean disable) {
        PacketBuffer buffer = PacketPipeline.buf();
        buffer.writeByte(disable ? 1 : 2);
        return buffer;
    }

    public static void sendToPlayer(EntityPlayer player, PacketBuffer packet) {
        if (ServerNetwork.hasBetterSprinting(player)) {
            PacketPipeline.sendToPlayer(packet, player);
        }
    }

    public static void sendToAll(List<? extends EntityPlayer> players, PacketBuffer packet) {
        for (EntityPlayer entityPlayer : players) {
            ServerNetwork.sendToPlayer(entityPlayer, packet);
        }
    }

    @Override
    public void onPacket(Side side, ByteBuf data, EntityPlayer player) {
        players.add(player.func_110124_au());
        if (ServerSettings.disableClientMod) {
            ServerNetwork.sendToPlayer(player, ServerNetwork.writeDisableMod(true));
        }
        if (ServerSettings.enableSurvivalFlyBoost || ServerSettings.enableAllDirs) {
            ServerNetwork.sendToPlayer(player, ServerNetwork.writeSettings(ServerSettings.enableSurvivalFlyBoost, ServerSettings.enableAllDirs));
        }
    }
}

