/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.system;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketPipeline {
    private static final String channelName = "BSM";
    private static PacketPipeline instance;
    private final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("BSM");
    private final INetworkHandler handler;

    public static void initialize(INetworkHandler handler) {
        if (instance != null) {
            throw new RuntimeException("Packet pipeline has already been registered!");
        }
        instance = new PacketPipeline(handler);
    }

    private PacketPipeline(INetworkHandler handler) {
        this.channel.register((Object)this);
        this.handler = handler;
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent e) {
        this.handler.onPacket(Side.CLIENT, e.getPacket().payload(), this.getClientPlayer());
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent e) {
        this.handler.onPacket(Side.SERVER, e.getPacket().payload(), (EntityPlayer)((NetHandlerPlayServer)e.getHandler()).field_147369_b);
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static PacketBuffer buf() {
        return new PacketBuffer(Unpooled.buffer());
    }

    public static void sendToPlayer(PacketBuffer buffer, EntityPlayer player) {
        PacketPipeline.instance.channel.sendTo(new FMLProxyPacket(buffer, channelName), (EntityPlayerMP)player);
    }

    public static void sendToServer(PacketBuffer buffer) {
        PacketPipeline.instance.channel.sendToServer(new FMLProxyPacket(buffer, channelName));
    }

    public static interface INetworkHandler {
        public void onPacket(Side var1, ByteBuf var2, EntityPlayer var3);
    }
}

