/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.system.core;

import chylex.bettersprinting.system.Log;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public final class TransformerEntityPlayerSP
implements IClassTransformer {
    private static final String[] NAMES_ONLIVINGUPDATE = new String[]{"n", "onLivingUpdate"};
    private static final String DESC_ONLIVINGUPDATE = "()V";

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.client.entity.EntityPlayerSP")) {
            ClassNode node = new ClassNode();
            ClassReader reader = new ClassReader(bytes);
            reader.accept((ClassVisitor)node, 0);
            this.transformEntityPlayerSP(node);
            ClassWriter writer = new ClassWriter(3);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return bytes;
    }

    private void transformEntityPlayerSP(ClassNode node) {
        MethodNode onLivingUpdate = node.methods.stream().filter(method -> method.desc.equals(DESC_ONLIVINGUPDATE) && ArrayUtils.contains((Object[])NAMES_ONLIVINGUPDATE, (Object)method.name)).findAny().orElseThrow(() -> {
            TransformerEntityPlayerSP.logMethods("onLivingUpdate", node);
            return new IllegalStateException("Better Sprinting failed modifying EntityPlayerSP - could not find onLivingUpdate. The mod has generated logs to help pinpointing the issue, please include them in your report.");
        });
        try {
            this.transformMovementInputUpdate(onLivingUpdate);
            this.transformSprinting(onLivingUpdate);
            this.transformAfterSuperCall(onLivingUpdate);
        }
        catch (Throwable t) {
            TransformerEntityPlayerSP.logInstructions(onLivingUpdate);
            throw new IllegalStateException("Better Sprinting failed modifying EntityPlayerSP. The mod has generated logs to help pinpointing the issue, please include them in your report.", t);
        }
    }

    private void transformMovementInputUpdate(MethodNode method) {
        Log.debug("Transforming onLivingUpdate (movement update)...", new Object[0]);
        InsnList instructions = method.instructions;
        int entry = -1;
        int instrcount = instructions.size();
        for (int index = 0; index < instrcount; ++index) {
            if (!TransformerEntityPlayerSP.checkMethodInstruction(instructions.get(index), 182, "updatePlayerMoveState", "a") || !TransformerEntityPlayerSP.checkOpcodeChain(instructions, index - 2, new int[]{25, 180})) continue;
            entry = index;
            break;
        }
        if (entry == -1) {
            throw new IllegalStateException("Could not find entry point.");
        }
        Log.debug("Found entry point at " + entry + ".", new Object[0]);
        AbstractInsnNode toRemove = instructions.get(entry - 1);
        AbstractInsnNode toReplace = instructions.get(entry);
        instructions.remove(toRemove);
        instructions.set(toReplace, (AbstractInsnNode)new MethodInsnNode(184, "chylex/bettersprinting/client/player/LivingUpdate", "injectMovementInputUpdate", "(Lnet/minecraft/client/entity/EntityPlayerSP;)V", false));
    }

    private void transformSprinting(MethodNode method) {
        Log.debug("Transforming onLivingUpdate (sprinting)...", new Object[0]);
        InsnList instructions = method.instructions;
        int[] bounds = null;
        int instrcount = instructions.size();
        for (int index = 0; index < instrcount; ++index) {
            if (!TransformerEntityPlayerSP.checkMethodInstruction(instructions.get(index), 182, "pushOutOfBlocks", "i") || !TransformerEntityPlayerSP.checkMethodInstruction(instructions.get(index - 25), 182, "pushOutOfBlocks", "i") || !TransformerEntityPlayerSP.checkMethodInstruction(instructions.get(index - 50), 182, "pushOutOfBlocks", "i") || !TransformerEntityPlayerSP.checkMethodInstruction(instructions.get(index - 75), 182, "pushOutOfBlocks", "i") || !TransformerEntityPlayerSP.checkMethodInstruction(instructions.get(index + 130), 182, "setSprinting", "f")) continue;
            bounds = new int[]{index + 2, index + 131};
            break;
        }
        if (bounds == null) {
            throw new IllegalStateException("Could not find entry point.");
        }
        Log.debug("Found insertion point at " + (int)bounds[0] + ", skip point at " + (int)bounds[1] + ".", new Object[0]);
        AbstractInsnNode[] labels = new AbstractInsnNode[]{instructions.get((int)bounds[0]), instructions.get((int)bounds[1])};
        TransformerEntityPlayerSP.validateLabels(labels[0], labels[1]);
        InsnList inserted = new InsnList();
        inserted.add((AbstractInsnNode)new MethodInsnNode(184, "chylex/bettersprinting/client/player/LivingUpdate", "injectSprinting", "()Z", false));
        inserted.add((AbstractInsnNode)new JumpInsnNode(154, (LabelNode)labels[1]));
        instructions.insert(labels[0], inserted);
    }

    private void transformAfterSuperCall(MethodNode method) {
        Log.debug("Transforming onLivingUpdate (super call)...", new Object[0]);
        InsnList instructions = method.instructions;
        int[] bounds = null;
        for (int index = instructions.size() - 1; index >= 0; --index) {
            if (!TransformerEntityPlayerSP.checkMethodInstruction(instructions.get(index), 183, method.name, null) || !TransformerEntityPlayerSP.checkMethodInstruction(instructions.get(index + 24), 182, "sendPlayerAbilities", "w")) continue;
            bounds = new int[]{index + 1, index + 25};
            break;
        }
        if (bounds == null) {
            throw new IllegalStateException("Could not find entry point.");
        }
        Log.debug("Found insertion point at " + (int)bounds[0] + ", skip point at " + (int)bounds[1] + ".", new Object[0]);
        AbstractInsnNode[] labels = new AbstractInsnNode[]{instructions.get((int)bounds[0]), instructions.get(bounds[1])};
        TransformerEntityPlayerSP.validateLabels(labels[0], labels[1]);
        InsnList inserted = new InsnList();
        inserted.add((AbstractInsnNode)new MethodInsnNode(184, "chylex/bettersprinting/client/player/LivingUpdate", "injectAfterSuperCall", "()Z", false));
        inserted.add((AbstractInsnNode)new JumpInsnNode(154, (LabelNode)labels[1]));
        instructions.insert(labels[0], inserted);
    }

    private static void validateLabels(AbstractInsnNode insertNode, AbstractInsnNode skipNode) {
        if (!(insertNode instanceof LabelNode)) {
            throw new IllegalStateException("Invalid insertion point node, expected label, got: " + insertNode.getClass().getSimpleName());
        }
        if (!(skipNode instanceof LabelNode)) {
            throw new IllegalStateException("Invalid insertion point node, expected label, got: " + skipNode.getClass().getSimpleName());
        }
    }

    private static boolean checkMethodInstruction(AbstractInsnNode instruction, int opcode, String name1, String name2) {
        if (instruction.getOpcode() != opcode) {
            return false;
        }
        String name = ((MethodInsnNode)instruction).name;
        return name.equals(name1) || name.equals(name2);
    }

    private static boolean checkOpcodeChain(InsnList instructions, int start, int[] chain) {
        for (int offset = 0; offset < chain.length; ++offset) {
            AbstractInsnNode instruction = instructions.get(start + offset);
            if (instruction.getOpcode() == chain[offset]) continue;
            Log.debug("Mismatched opcode chain, $0 != $1", instruction.getOpcode(), chain[offset]);
            return false;
        }
        return true;
    }

    private static void logMethods(String missingMethod, ClassNode owner) {
        Log.error("Better Sprinting could not find EntityPlayerSP.$0, generating debug logs...", missingMethod);
        for (MethodNode method : owner.methods) {
            Log.error("> $0 .. $1", method.name, method.desc);
        }
    }

    private static void logInstructions(MethodNode method) {
        TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)new Textifier());
        ListIterator iter = method.instructions.iterator();
        while (iter.hasNext()) {
            ((AbstractInsnNode)iter.next()).accept((MethodVisitor)visitor);
        }
        int index = 0;
        for (Object obj : visitor.p.getText()) {
            Log.error("> $0: $1", ++index, StringUtils.stripEnd((String)obj.toString(), null));
        }
    }
}

