/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting;

import chylex.bettersprinting.BetterSprintingMod;
import chylex.bettersprinting.system.Log;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class BetterSprintingConfig {
    private final ModConfig config;
    private static Path migrationFile = null;
    private static boolean isNew = false;

    BetterSprintingConfig(ModConfig config) {
        this.config = config;
    }

    public boolean isNew() {
        return isNew;
    }

    public void save() {
        this.config.save();
    }

    public <T> void set(ForgeConfigSpec.ConfigValue<T> property, T value) {
        this.config.getConfigData().set(property.getPath(), value);
    }

    public <T> void update(ForgeConfigSpec.ConfigValue<T> property, Function<T, T> func) {
        this.set(property, func.apply(property.get()));
    }

    void migrate() {
        if (migrationFile != null && Files.exists(migrationFile, new LinkOption[0])) {
            BetterSprintingMod.proxy.migrateConfig(BetterSprintingConfig.readOldConfig(migrationFile));
            this.save();
        }
    }

    public static void register(ModLoadingContext context, ModConfig.Type type, ForgeConfigSpec spec, String suffix) {
        String fileName = "bettersprinting-" + suffix + ".toml";
        context.registerConfig(type, spec, fileName);
        if (Files.notExists(Paths.get("config", fileName), new LinkOption[0])) {
            migrationFile = Paths.get("config", "bettersprinting.cfg").toAbsolutePath();
            isNew = true;
        }
    }

    private static Triple<Character, String, String> readOldConfigEntry(String trimmedLine) {
        String[] contents = trimmedLine.substring(2).split("=", 2);
        return new ImmutableTriple((Object)Character.valueOf(trimmedLine.charAt(0)), (Object)contents[0], (Object)contents[1]);
    }

    private static List<Triple<Character, String, String>> readOldConfig(Path oldFilePath) {
        ArrayList<Triple<Character, String, String>> oldConfig = new ArrayList<Triple<Character, String, String>>();
        try {
            Files.readAllLines(oldFilePath).stream().map(String::trim).filter(line -> line.length() > 4 && line.charAt(1) == ':').map(BetterSprintingConfig::readOldConfigEntry).forEach(oldConfig::add);
        }
        catch (IOException e) {
            Log.throwable(e, "Failed migrating old configuration.", new Object[0]);
        }
        return oldConfig;
    }
}

