/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client;

import chylex.bettersprinting.client.ClientModManager;
import chylex.bettersprinting.client.ClientNetwork;
import chylex.bettersprinting.client.ClientSettings;
import chylex.bettersprinting.client.gui.GuiButton;
import chylex.bettersprinting.client.gui.GuiSprint;
import chylex.bettersprinting.client.player.IntegrityCheck;
import chylex.bettersprinting.client.player.LivingUpdate;
import chylex.bettersprinting.client.update.UpdateNotificationManager;
import chylex.bettersprinting.system.PacketPipeline;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.gui.GuiKeyBindingList;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="bettersprinting")
public final class ClientEventHandler {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static boolean stopCheckingNewServer;
    public static boolean showDisableWarningWhenPossible;

    @SubscribeEvent
    public static void onPlayerLoginClient(PlayerEvent.PlayerLoggedInEvent e) {
        IntegrityCheck.register();
        UpdateNotificationManager.run();
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinWorldEvent e) {
        if (stopCheckingNewServer || e.getEntity() != ClientEventHandler.mc.field_71439_g) {
            return;
        }
        stopCheckingNewServer = true;
        if (!mc.func_71387_A() && mc.func_147104_D() != null && !((Boolean)ClientSettings.disableMod.get()).booleanValue()) {
            PacketPipeline.sendToServer(ClientNetwork.writeModNotification(10));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onGuiOpen(GuiOpenEvent e) {
        if (stopCheckingNewServer && mc.func_175606_aa() == null) {
            ClientModManager.onDisconnectedFromServer();
            IntegrityCheck.unregister();
            LivingUpdate.cleanup();
            stopCheckingNewServer = false;
            showDisableWarningWhenPossible = false;
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END || ClientEventHandler.mc.field_71439_g == null) {
            return;
        }
        if (showDisableWarningWhenPossible) {
            ClientEventHandler.mc.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(ClientModManager.chatPrefix + I18n.func_135052_a((String)(ClientModManager.svDisableMod ? "bs.game.disabled" : "bs.game.reenabled"), (Object[])new Object[0])));
            showDisableWarningWhenPossible = false;
        }
        if (ClientModManager.keyBindOptionsMenu.func_151470_d()) {
            mc.func_147108_a((GuiScreen)new GuiSprint(null));
        }
    }

    @SubscribeEvent
    public static void onGuiInitPost(GuiScreenEvent.InitGuiEvent.Post e) {
        GuiScreen gui = e.getGui();
        if (gui instanceof GuiControls) {
            GuiControls controls = (GuiControls)gui;
            e.getButtonList().stream().filter(btn -> btn instanceof GuiOptionButton && btn.field_146127_k == GameSettings.Options.AUTO_JUMP.func_74381_c()).findFirst().ifPresent(arg_0 -> ((GuiScreenEvent.InitGuiEvent.Post)e).removeButton(arg_0));
            controls.field_146494_r.field_195087_v.removeIf(entry -> entry instanceof GuiKeyBindingList.KeyEntry && ArrayUtils.contains((Object[])ClientModManager.keyBindings, (Object)((GuiKeyBindingList.KeyEntry)entry).field_148282_b) || entry instanceof GuiKeyBindingList.CategoryEntry && ((GuiKeyBindingList.CategoryEntry)entry).field_148285_b.equals(I18n.func_135052_a((String)"key.categories.bettersprinting.hidden", (Object[])new Object[0])));
            if (!(controls.field_146496_h instanceof GuiSprint)) {
                e.addButton((net.minecraft.client.gui.GuiButton)new GuiButton(6969, controls.field_146294_l / 2 + 5, 42, 150, "Better Sprinting", () -> mc.func_147108_a((GuiScreen)new GuiSprint(ClientEventHandler.mc.field_71462_r))));
            }
        }
    }

    private ClientEventHandler() {
    }
}

