/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client.gui;

import chylex.bettersprinting.BetterSprintingMod;
import chylex.bettersprinting.client.ClientModManager;
import chylex.bettersprinting.client.ClientSettings;
import chylex.bettersprinting.client.gui.GuiButton;
import chylex.bettersprinting.client.gui.GuiButtonCustomInput;
import chylex.bettersprinting.client.gui.GuiButtonInputBinding;
import chylex.bettersprinting.client.gui.GuiButtonInputOption;
import chylex.bettersprinting.client.input.SprintKeyMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.KeyModifier;

@OnlyIn(value=Dist.CLIENT)
public class GuiSprint
extends GuiScreen {
    private static final int idDoubleTap = 199;
    private static final int idAllDirs = 198;
    private static final int idFlyBoost = 197;
    private static final int idFlyOnGround = 196;
    private static final int idDisableMod = 195;
    private static final int idAutoJump = 194;
    private static final int idKeyBindStart = 200;
    private static final int idSprintMode = 193;
    private static final int idDone = 192;
    private static final int idControls = 191;
    private final Minecraft mc = Minecraft.func_71410_x();
    private final GuiScreen parentScreen;
    private GuiButton btnSprintMode;
    private GuiButtonInputOption btnDoubleTap;
    private GuiButtonInputOption btnAutoJump;
    private GuiButtonInputOption btnFlyBoost;
    private GuiButtonInputOption btnFlyOnGround;
    private GuiButtonInputOption btnAllDirs;
    private GuiButtonInputOption btnDisableMod;
    private GuiButtonInputBinding selectedBinding;

    public GuiSprint(GuiScreen parentScreen) {
        this.parentScreen = parentScreen;
    }

    protected void func_73866_w_() {
        this.field_146292_n.clear();
        int left = this.field_146294_l / 2 - 155;
        int top = this.field_146295_m / 6;
        for (int index = 0; index < ClientModManager.keyBindings.length; ++index) {
            this.func_189646_b(new GuiButtonInputBinding(200 + index, left + 160 * (index % 2), top + 24 * (index / 2), ClientModManager.keyBindings[index], this::onBindingClicked));
        }
        this.btnSprintMode = (GuiButton)this.func_189646_b((net.minecraft.client.gui.GuiButton)new GuiButton(193, left - 50, top, 48, "", this::onClickedSprintMode));
        this.btnDoubleTap = (GuiButtonInputOption)this.func_189646_b(new GuiButtonInputOption(199, left, top + 60, "bs.doubleTapping", this::onButtonClicked));
        this.btnAllDirs = (GuiButtonInputOption)this.func_189646_b(new GuiButtonInputOption(198, left + 160, top + 60, "bs.runAllDirs", this::onButtonClicked));
        this.btnFlyBoost = (GuiButtonInputOption)this.func_189646_b(new GuiButtonInputOption(197, left, top + 84, "bs.flyBoost", this::onButtonClicked));
        this.btnFlyOnGround = (GuiButtonInputOption)this.func_189646_b(new GuiButtonInputOption(196, left + 160, top + 84, "bs.flyOnGround", this::onButtonClicked));
        this.btnDisableMod = (GuiButtonInputOption)this.func_189646_b(new GuiButtonInputOption(195, left + 160, top + 108, "bs.disableMod", this::onButtonClicked));
        this.btnAutoJump = (GuiButtonInputOption)this.func_189646_b(new GuiButtonInputOption(194, left, top + 108, "bs.autoJump", this::onButtonClicked));
        this.func_189646_b((net.minecraft.client.gui.GuiButton)new GuiButton(192, this.field_146294_l / 2 - 100, top + 168, this.parentScreen == null ? 98 : 200, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), this::onClickedDone));
        if (this.parentScreen == null) {
            this.func_189646_b((net.minecraft.client.gui.GuiButton)new GuiButton(191, this.field_146294_l / 2 + 2, top + 168, 98, I18n.func_135052_a((String)"options.controls", (Object[])new Object[0]), this::onClickedControls));
        }
        this.updateButtonState();
        this.updateButtonText();
    }

    private void updateButtonState() {
        for (net.minecraft.client.gui.GuiButton button : this.field_146292_n) {
            KeyBinding binding;
            if (!(button instanceof GuiButtonInputBinding) || (binding = ((GuiButtonInputBinding)button).binding) != ClientModManager.keyBindSprintToggle && binding != ClientModManager.keyBindSneakToggle) continue;
            button.field_146124_l = !ClientModManager.isModDisabled();
        }
        this.btnSprintMode.field_146124_l = !ClientModManager.isModDisabled();
        this.btnDoubleTap.field_146124_l = !ClientModManager.isModDisabled();
        this.btnAllDirs.field_146124_l = ClientModManager.Feature.RUN_IN_ALL_DIRS.isAvailable();
        this.btnFlyBoost.field_146124_l = ClientModManager.Feature.FLY_BOOST.isAvailable();
        this.btnFlyOnGround.field_146124_l = ClientModManager.Feature.FLY_ON_GROUND.isAvailable();
        this.btnDisableMod.field_146124_l = ClientModManager.canManuallyEnableMod();
    }

    private void updateButtonText() {
        this.btnSprintMode.setMessage(I18n.func_135052_a((String)(ClientModManager.isModDisabled() ? SprintKeyMode.TAP : (SprintKeyMode)((Object)ClientSettings.sprintKeyMode.get())).translationKey, (Object[])new Object[0]));
        this.btnDoubleTap.setTitleKey(ClientModManager.isModDisabled() ? "gui.unavailable" : ((Boolean)ClientSettings.enableDoubleTap.get() != false ? "gui.enabled" : "gui.disabled"));
        this.btnFlyBoost.setTitleKey(ClientModManager.Feature.FLY_BOOST.isAvailable() ? ((Integer)ClientSettings.flySpeedBoost.get() == 0 ? "gui.disabled" : (Integer)ClientSettings.flySpeedBoost.get() + 1 + "x") : "gui.unavailable");
        this.btnFlyOnGround.setTitleKey(ClientModManager.Feature.FLY_ON_GROUND.isAvailable() ? (((Boolean)ClientSettings.flyOnGround.get()).booleanValue() ? "gui.enabled" : "gui.disabled") : "gui.unavailable");
        this.btnAllDirs.setTitleKey(ClientModManager.Feature.RUN_IN_ALL_DIRS.isAvailable() ? (((Boolean)ClientSettings.enableAllDirs.get()).booleanValue() ? "gui.enabled" : "gui.disabled") : "gui.unavailable");
        this.btnDisableMod.setTitleKey(ClientModManager.isModDisabled() ? "gui.yes" : "gui.no");
        this.btnAutoJump.setTitleKey(this.mc.field_71474_y.field_189989_R ? "gui.yes" : "gui.no");
    }

    private void onClickedControls() {
        this.mc.func_147108_a((GuiScreen)new GuiControls((GuiScreen)this, this.mc.field_71474_y));
        BetterSprintingMod.config.save();
    }

    private void onClickedDone() {
        this.mc.func_147108_a(this.parentScreen);
        BetterSprintingMod.config.save();
    }

    private void onClickedSprintMode() {
        BetterSprintingMod.config.update(ClientSettings.sprintKeyMode, SprintKeyMode::next);
        BetterSprintingMod.config.save();
        this.updateButtonText();
    }

    private void onBindingClicked(GuiButtonInputBinding binding) {
        if (this.selectedBinding != null) {
            this.selectedBinding.setSelected(false);
        }
        this.selectedBinding = binding;
        this.selectedBinding.setSelected(true);
    }

    private void onButtonClicked(int id) {
        switch (id) {
            case 194: {
                this.mc.field_71474_y.field_189989_R = !this.mc.field_71474_y.field_189989_R;
                this.mc.field_71474_y.func_74303_b();
                break;
            }
            case 195: {
                if (!ClientModManager.canManuallyEnableMod()) break;
                BetterSprintingMod.config.update(ClientSettings.disableMod, value -> value == false);
                this.updateButtonState();
                this.updateButtonText();
                break;
            }
            case 197: {
                if (!ClientModManager.Feature.FLY_BOOST.isAvailable()) break;
                BetterSprintingMod.config.update(ClientSettings.flySpeedBoost, value -> (value + 1) % 8);
                break;
            }
            case 196: {
                if (!ClientModManager.Feature.FLY_ON_GROUND.isAvailable()) break;
                BetterSprintingMod.config.update(ClientSettings.flyOnGround, value -> value == false);
                break;
            }
            case 198: {
                if (!ClientModManager.Feature.RUN_IN_ALL_DIRS.isAvailable()) break;
                BetterSprintingMod.config.update(ClientSettings.enableAllDirs, value -> value == false);
                break;
            }
            case 199: {
                if (((Boolean)ClientSettings.disableMod.get()).booleanValue()) break;
                BetterSprintingMod.config.update(ClientSettings.enableDoubleTap, value -> value == false);
                break;
            }
            default: {
                return;
            }
        }
        BetterSprintingMod.config.save();
        this.updateButtonText();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.selectedBinding != null) {
            this.selectedBinding.setBinding(InputMappings.Type.MOUSE.func_197944_a(button));
            this.onSelectedBindingUpdated();
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.selectedBinding != null) {
            if (keyCode == 256) {
                this.selectedBinding.setBinding(KeyModifier.NONE, InputMappings.field_197958_a);
            } else {
                this.selectedBinding.setBinding(KeyModifier.getActiveModifier(), InputMappings.func_197954_a((int)keyCode, (int)scanCode));
            }
            this.onSelectedBindingUpdated();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.selectedBinding != null) {
            this.selectedBinding.setBinding(KeyModifier.NONE, InputMappings.func_197954_a((int)keyCode, (int)scanCode));
            this.onSelectedBindingUpdated();
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    private void onSelectedBindingUpdated() {
        if (!this.selectedBinding.isSelected()) {
            this.selectedBinding = null;
        }
        for (net.minecraft.client.gui.GuiButton button : this.field_146292_n) {
            if (!(button instanceof GuiButtonInputBinding)) continue;
            ((GuiButtonInputBinding)button).updateKeyBindingText();
        }
        ClientSettings.keyInfoSprintHold.readFrom(ClientModManager.keyBindSprintHold);
        ClientSettings.keyInfoSprintToggle.readFrom(ClientModManager.keyBindSprintToggle);
        ClientSettings.keyInfoSneakToggle.readFrom(ClientModManager.keyBindSneakToggle);
        ClientSettings.keyInfoOptionsMenu.readFrom(ClientModManager.keyBindOptionsMenu);
        KeyBinding.func_74508_b();
        this.mc.field_71474_y.func_74303_b();
        BetterSprintingMod.config.save();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTickTime) {
        int top = this.field_146295_m / 6;
        int middle = this.field_146294_l / 2;
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, "Better Sprinting", middle, 20, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTickTime);
        int maxWidthLeft = 82;
        int maxWidthRight = 124;
        for (net.minecraft.client.gui.GuiButton button : this.field_146292_n) {
            if (!(button instanceof GuiButtonCustomInput)) continue;
            this.drawButtonTitle(((GuiButtonCustomInput)button).getTitle(), button, button.field_146128_h < middle ? 82 : 124);
            if (!button.func_146115_a()) continue;
            String[] spl = ((GuiButtonCustomInput)button).getInfo();
            for (int line = 0; line < spl.length; ++line) {
                this.func_73732_a(this.field_146289_q, spl[line], middle, top + 148 + (10 * line - this.field_146289_q.field_78288_b * spl.length / 2), -1);
            }
        }
    }

    private void drawButtonTitle(String title, net.minecraft.client.gui.GuiButton btn, int maxWidth) {
        int lines = this.field_146289_q.func_78271_c(title, maxWidth).size();
        this.field_146289_q.func_78279_b(title, btn.field_146128_h + 76, btn.field_146129_i + 7 - 5 * (lines - 1), maxWidth, -1);
    }
}

