/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.server;

import chylex.bettersprinting.server.ServerSettings;
import chylex.bettersprinting.system.PacketPipeline;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

@OnlyIn(value=Dist.DEDICATED_SERVER)
final class ServerNetwork
implements PacketPipeline.INetworkHandler {
    private static final Set<UUID> players = Collections.synchronizedSet(new HashSet());

    ServerNetwork() {
    }

    public static boolean hasBetterSprinting(EntityPlayer player) {
        return players.contains(player.func_110124_au());
    }

    public static void onDisconnected(EntityPlayer player) {
        players.remove(player.func_110124_au());
    }

    public static PacketBuffer writeSettings(boolean enableSurvivalFlyBoost, boolean enableAllDirs) {
        PacketBuffer buffer = PacketPipeline.buf();
        buffer.writeByte(0).writeBoolean(enableSurvivalFlyBoost).writeBoolean(enableAllDirs);
        return buffer;
    }

    public static PacketBuffer writeDisableMod(boolean disable) {
        PacketBuffer buffer = PacketPipeline.buf();
        buffer.writeByte(disable ? 1 : 2);
        return buffer;
    }

    public static void sendToPlayer(EntityPlayer player, PacketBuffer packet) {
        if (ServerNetwork.hasBetterSprinting(player)) {
            PacketPipeline.sendToPlayer(packet, player);
        }
    }

    public static void sendToAll(List<? extends EntityPlayer> players, PacketBuffer packet) {
        for (EntityPlayer entityPlayer : players) {
            ServerNetwork.sendToPlayer(entityPlayer, packet);
        }
    }

    @Override
    public void onPacket(LogicalSide side, ByteBuf data, EntityPlayer player) {
        players.add(player.func_110124_au());
        if (((Boolean)ServerSettings.disableClientMod.get()).booleanValue()) {
            ServerNetwork.sendToPlayer(player, ServerNetwork.writeDisableMod(true));
        }
        if (((Boolean)ServerSettings.enableSurvivalFlyBoost.get()).booleanValue() || ((Boolean)ServerSettings.enableAllDirs.get()).booleanValue()) {
            ServerNetwork.sendToPlayer(player, ServerNetwork.writeSettings((Boolean)ServerSettings.enableSurvivalFlyBoost.get(), (Boolean)ServerSettings.enableAllDirs.get()));
        }
    }
}

