/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client.gui;

import chylex.bettersprinting.client.gui.GuiButtonCustomInput;
import java.util.function.Consumer;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.KeyModifier;

@OnlyIn(value=Dist.CLIENT)
public final class GuiButtonInputBinding
extends GuiButtonCustomInput<GuiButtonInputBinding> {
    private static final GameSettings settings = Minecraft.func_71410_x().field_71474_y;
    public final KeyBinding binding;
    private boolean isSelected;

    public GuiButtonInputBinding(int x, int y, KeyBinding binding, Consumer<GuiButtonInputBinding> onClick) {
        super(x, y, "", binding == GuiButtonInputBinding.settings.field_151444_V ? "bs.sprint.hold" : binding.func_151464_g(), onClick);
        this.binding = binding;
        this.updateKeyBindingText();
    }

    @Override
    protected GuiButtonInputBinding getContext() {
        return this;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
        this.updateKeyBindingText();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setBinding(InputMappings.Input input) {
        this.binding.func_197979_b(input);
        this.isSelected = false;
    }

    public void setBinding(KeyModifier modifier, InputMappings.Input input) {
        this.binding.setKeyModifierAndCode(modifier, input);
        this.isSelected &= KeyModifier.isKeyCodeModifier((InputMappings.Input)input) && modifier != KeyModifier.NONE;
    }

    public void updateKeyBindingText() {
        boolean hasConflict = false;
        boolean hasOnlyModifierConflict = true;
        if (!this.binding.func_197986_j()) {
            for (KeyBinding other : GuiButtonInputBinding.settings.field_74324_K) {
                if (this.binding == other || !this.binding.func_197983_b(other)) continue;
                hasConflict = true;
                hasOnlyModifierConflict &= this.binding.hasKeyCodeModifierConflict(other);
            }
        }
        if (this.isSelected) {
            this.setMessage(TextFormatting.WHITE + "> " + TextFormatting.YELLOW + this.binding.func_197978_k() + TextFormatting.WHITE + " <");
        } else if (hasConflict) {
            this.setMessage((hasOnlyModifierConflict ? TextFormatting.GOLD : TextFormatting.RED) + this.binding.func_197978_k());
        } else {
            this.setMessage(this.binding.func_197978_k());
        }
    }
}

