/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.system;

import chylex.bettersprinting.BetterSprintingMod;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SharedConstants;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;

public final class Log {
    private static final boolean isDeobfEnvironment = System.getProperty("bettersprinting.debug") != null;
    private static final Logger logger = LogManager.getLogger((String)"BetterSprinting");

    public static void load() {
        if (isDeobfEnvironment) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> Log::loadDeobfClient);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void loadDeobfClient() {
        String title = "Minecraft " + SharedConstants.func_215069_a().getName() + " - BetterSprinting " + BetterSprintingMod.modVersion;
        Minecraft mc = Minecraft.func_71410_x();
        mc.execute(() -> GLFW.glfwSetWindowTitle((long)mc.field_195558_d.func_198092_i(), (CharSequence)title));
    }

    public static void debug(String message, Object ... data) {
        if (isDeobfEnvironment) {
            logger.info(Log.getMessage(message, data));
        }
    }

    public static void error(String message, Object ... data) {
        logger.error(Log.getMessage(message, data));
    }

    public static void throwable(Throwable throwable, String message, Object ... data) {
        logger.catching(Level.ERROR, throwable);
        logger.error(Log.getMessage(message, data));
    }

    private static String getMessage(String message, Object ... data) {
        for (int a = data.length - 1; a >= 0; --a) {
            message = message.replace("$" + a, data[a] == null ? "null" : String.valueOf(data[a]));
        }
        return message;
    }
}

