/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.system;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public class PacketPipeline {
    private static final ResourceLocation channelName = new ResourceLocation("bsm", "settings");
    private static final String protocolId = "1";
    private static boolean registered = false;
    private final INetworkHandler handler;

    public static void initialize(INetworkHandler handler) {
        if (registered) {
            throw new RuntimeException("Packet pipeline has already been registered!");
        }
        NetworkRegistry.newEventChannel((ResourceLocation)channelName, () -> protocolId, protocolServer -> true, protocolClient -> true).registerObject((Object)new PacketPipeline(handler));
        registered = true;
    }

    private PacketPipeline(INetworkHandler handler) {
        this.handler = handler;
    }

    @SubscribeEvent
    public void onServerToClientPacket(NetworkEvent.ServerCustomPayloadEvent e) {
        this.handlePacket(LogicalSide.CLIENT, this.getClientPlayer(), e.getPayload().copy(), (NetworkEvent.Context)e.getSource().get());
    }

    @SubscribeEvent
    public void onClientToServerPacket(NetworkEvent.ClientCustomPayloadEvent e) {
        NetworkEvent.Context ctx = (NetworkEvent.Context)e.getSource().get();
        this.handlePacket(LogicalSide.SERVER, (PlayerEntity)ctx.getSender(), e.getPayload().copy(), ctx);
    }

    private void handlePacket(LogicalSide side, PlayerEntity player, ByteBuf payload, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> this.handler.onPacket(side, payload, player));
    }

    @OnlyIn(value=Dist.CLIENT)
    private PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static PacketBuffer buf() {
        return new PacketBuffer(Unpooled.buffer());
    }

    public static void sendToPlayer(PacketBuffer buffer, PlayerEntity player) {
        PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player).send(NetworkDirection.PLAY_TO_CLIENT.buildPacket(Pair.of((Object)buffer, (Object)0), channelName).getThis());
    }

    public static void sendToServer(PacketBuffer buffer) {
        PacketDistributor.SERVER.noArg().send(NetworkDirection.PLAY_TO_SERVER.buildPacket(Pair.of((Object)buffer, (Object)0), channelName).getThis());
    }

    public static interface INetworkHandler {
        public void onPacket(LogicalSide var1, ByteBuf var2, PlayerEntity var3);
    }
}

