/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client;

import chylex.bettersprinting.client.ClientEventHandler;
import chylex.bettersprinting.client.ClientModManager;
import chylex.bettersprinting.client.ClientSettings;
import chylex.bettersprinting.system.PacketPipeline;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

@OnlyIn(value=Dist.CLIENT)
public final class ClientNetwork
implements PacketPipeline.INetworkHandler {
    public static PacketBuffer writeModNotification(int protocol) {
        PacketBuffer buffer = PacketPipeline.buf();
        buffer.writeByte(0).writeByte(protocol);
        return buffer;
    }

    private static PacketBuffer writeLanSettings() {
        PacketBuffer buffer = PacketPipeline.buf();
        buffer.writeByte(0).writeBoolean(false).writeBoolean(true);
        return buffer;
    }

    @Override
    public void onPacket(LogicalSide side, ByteBuf data, PlayerEntity player) {
        if (side == LogicalSide.SERVER) {
            PacketPipeline.sendToPlayer(ClientNetwork.writeLanSettings(), player);
            return;
        }
        byte type = data.readByte();
        if (type == 0) {
            ClientModManager.svSurvivalFlyBoost = data.readBoolean();
            ClientModManager.svRunInAllDirs = data.readBoolean();
        } else if (type == 1 && !((Boolean)ClientSettings.disableMod.get()).booleanValue()) {
            ClientModManager.svDisableMod = true;
            ClientEventHandler.showDisableWarningWhenPossible = true;
        } else if (type == 2 && !((Boolean)ClientSettings.disableMod.get()).booleanValue()) {
            ClientModManager.svDisableMod = false;
            ClientEventHandler.showDisableWarningWhenPossible = true;
        }
    }
}

