/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client;

import chylex.bettersprinting.BetterSprintingConfig;
import chylex.bettersprinting.BetterSprintingMod;
import chylex.bettersprinting.client.input.KeyBindingInfo;
import chylex.bettersprinting.client.input.SprintKeyMode;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

@OnlyIn(value=Dist.CLIENT)
public final class ClientSettings {
    private static final ForgeConfigSpec.IntValue keyCodeSprintHold;
    private static final ForgeConfigSpec.IntValue keyCodeSprintToggle;
    private static final ForgeConfigSpec.IntValue keyCodeSneakToggle;
    private static final ForgeConfigSpec.IntValue keyCodeOptionsMenu;
    private static final ForgeConfigSpec.EnumValue<KeyModifier> keyModSprintHold;
    private static final ForgeConfigSpec.EnumValue<KeyModifier> keyModSprintToggle;
    private static final ForgeConfigSpec.EnumValue<KeyModifier> keyModSneakToggle;
    private static final ForgeConfigSpec.EnumValue<KeyModifier> keyModOptionsMenu;
    private static final ForgeConfigSpec.EnumValue<InputMappings.Type> keyTypeSprintHold;
    private static final ForgeConfigSpec.EnumValue<InputMappings.Type> keyTypeSprintToggle;
    private static final ForgeConfigSpec.EnumValue<InputMappings.Type> keyTypeSneakToggle;
    private static final ForgeConfigSpec.EnumValue<InputMappings.Type> keyTypeOptionsMenu;
    public static final KeyBindingInfo keyInfoSprintHold;
    public static final KeyBindingInfo keyInfoSprintToggle;
    public static final KeyBindingInfo keyInfoSneakToggle;
    public static final KeyBindingInfo keyInfoOptionsMenu;
    public static final ForgeConfigSpec.EnumValue<SprintKeyMode> sprintKeyMode;
    public static final ForgeConfigSpec.IntValue flySpeedBoost;
    public static final ForgeConfigSpec.BooleanValue flyOnGround;
    public static final ForgeConfigSpec.BooleanValue enableDoubleTap;
    public static final ForgeConfigSpec.BooleanValue enableAllDirs;
    public static final ForgeConfigSpec.BooleanValue disableMod;
    private static final ForgeConfigSpec configSpec;

    static void register(ModLoadingContext ctx) {
        BetterSprintingConfig.register(ctx, ModConfig.Type.CLIENT, configSpec, "client");
    }

    public static void firstTimeSetup() {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        keyInfoSprintHold.readFrom(settings.field_151444_V);
        KeyModifier sprintModifier = ClientSettings.getVanillaKeyModifier(settings.field_151444_V);
        KeyModifier sneakModifier = ClientSettings.getVanillaKeyModifier(settings.field_228046_af_);
        if (sprintModifier != KeyModifier.NONE) {
            keyInfoSprintToggle.set(sprintModifier, InputMappings.Type.KEYSYM.func_197944_a(71));
        }
        if (sneakModifier != KeyModifier.NONE) {
            keyInfoSneakToggle.set(sneakModifier, InputMappings.Type.KEYSYM.func_197944_a(71));
        }
        BetterSprintingMod.config.save();
    }

    private static KeyModifier getVanillaKeyModifier(KeyBinding binding) {
        if (binding.getKeyModifier() != KeyModifier.NONE || binding.getKey().func_197938_b() != InputMappings.Type.KEYSYM) {
            return KeyModifier.NONE;
        }
        switch (binding.getKey().func_197937_c()) {
            case 341: {
                return KeyModifier.CONTROL;
            }
            case 340: {
                return KeyModifier.SHIFT;
            }
            case 342: {
                return KeyModifier.ALT;
            }
        }
        return KeyModifier.NONE;
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("client");
        keyCodeSprintHold = builder.defineInRange("keyCodeSprintHold", 341, Integer.MIN_VALUE, Integer.MAX_VALUE);
        keyCodeSprintToggle = builder.defineInRange("keyCodeSprintToggle", 71, Integer.MIN_VALUE, Integer.MAX_VALUE);
        keyCodeSneakToggle = builder.defineInRange("keyCodeSneakToggle", 90, Integer.MIN_VALUE, Integer.MAX_VALUE);
        keyCodeOptionsMenu = builder.defineInRange("keyCodeOptionsMenu", 79, Integer.MIN_VALUE, Integer.MAX_VALUE);
        keyModSprintHold = builder.defineEnum("keyModSprintHold", () -> KeyModifier.NONE, obj -> true, KeyModifier.class);
        keyModSprintToggle = builder.defineEnum("keyModSprintToggle", () -> KeyModifier.NONE, obj -> true, KeyModifier.class);
        keyModSneakToggle = builder.defineEnum("keyModSneakToggle", () -> KeyModifier.NONE, obj -> true, KeyModifier.class);
        keyModOptionsMenu = builder.defineEnum("keyModOptionsMenu", () -> KeyModifier.NONE, obj -> true, KeyModifier.class);
        keyTypeSprintHold = builder.defineEnum("keyTypeSprintHold", (Enum)InputMappings.Type.KEYSYM);
        keyTypeSprintToggle = builder.defineEnum("keyTypeSprintToggle", (Enum)InputMappings.Type.KEYSYM);
        keyTypeSneakToggle = builder.defineEnum("keyTypeSneakToggle", (Enum)InputMappings.Type.KEYSYM);
        keyTypeOptionsMenu = builder.defineEnum("keyTypeOptionsMenu", (Enum)InputMappings.Type.KEYSYM);
        sprintKeyMode = builder.defineEnum("sprintKeyMode", (Enum)SprintKeyMode.TAP);
        flySpeedBoost = builder.defineInRange("flySpeedBoost", 3, 0, 7);
        flyOnGround = builder.define("flyOnGround", false);
        enableDoubleTap = builder.define("enableDoubleTap", false);
        enableAllDirs = builder.define("enableAllDirs", false);
        disableMod = builder.define("disableMod", false);
        builder.pop();
        configSpec = builder.build();
        keyInfoSprintHold = new KeyBindingInfo(keyCodeSprintHold, keyModSprintHold, keyTypeSprintHold);
        keyInfoSprintToggle = new KeyBindingInfo(keyCodeSprintToggle, keyModSprintToggle, keyTypeSprintToggle);
        keyInfoSneakToggle = new KeyBindingInfo(keyCodeSneakToggle, keyModSneakToggle, keyTypeSneakToggle);
        keyInfoOptionsMenu = new KeyBindingInfo(keyCodeOptionsMenu, keyModOptionsMenu, keyTypeOptionsMenu);
    }
}

