/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client.gui;

import chylex.bettersprinting.BetterSprintingMod;
import chylex.bettersprinting.client.ClientEventHandler;
import chylex.bettersprinting.client.ClientModManager;
import chylex.bettersprinting.client.ClientSettings;
import chylex.bettersprinting.client.gui.GuiButton;
import chylex.bettersprinting.client.gui.GuiButtonCustomInput;
import chylex.bettersprinting.client.gui.GuiButtonInputBinding;
import chylex.bettersprinting.client.gui.GuiButtonInputOption;
import chylex.bettersprinting.client.input.SprintKeyMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.KeyModifier;

@OnlyIn(value=Dist.CLIENT)
public class GuiSprint
extends Screen {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private final Screen parentScreen;
    private Button btnSprintMode;
    private GuiButtonInputOption btnDoubleTap;
    private GuiButtonInputOption btnAutoJump;
    private GuiButtonInputOption btnFlyBoost;
    private GuiButtonInputOption btnFlyOnGround;
    private GuiButtonInputOption btnAllDirs;
    private GuiButtonInputOption btnDisableMod;
    private GuiButtonInputBinding selectedBinding;

    public GuiSprint(Screen parentScreen) {
        super((ITextComponent)new StringTextComponent("Better Sprinting"));
        this.parentScreen = parentScreen;
    }

    protected void init() {
        this.buttons.clear();
        int left = this.width / 2 - 155;
        int top = this.height / 6;
        for (int index = 0; index < ClientModManager.keyBindings.length; ++index) {
            this.addButton((Widget)new GuiButtonInputBinding(left + 160 * (index % 2), top + 24 * (index / 2), ClientModManager.keyBindings[index], this::onBindingClicked));
        }
        this.btnSprintMode = (Button)this.addButton((Widget)new GuiButton(left - 50, top, 48, "", this.onSettingClicked(() -> BetterSprintingMod.config.update(ClientSettings.sprintKeyMode, SprintKeyMode::next))));
        this.btnDoubleTap = (GuiButtonInputOption)this.addButton((Widget)new GuiButtonInputOption(left, top + 60, "bs.doubleTapping", this.onSettingClicked(() -> {
            if (!((Boolean)ClientSettings.disableMod.get()).booleanValue()) {
                BetterSprintingMod.config.update(ClientSettings.enableDoubleTap, value -> value == false);
            }
        })));
        this.btnAllDirs = (GuiButtonInputOption)this.addButton((Widget)new GuiButtonInputOption(left + 160, top + 60, "bs.runAllDirs", this.onSettingClicked(() -> {
            if (ClientModManager.Feature.RUN_IN_ALL_DIRS.isAvailable()) {
                BetterSprintingMod.config.update(ClientSettings.enableAllDirs, value -> value == false);
            }
        })));
        this.btnFlyBoost = (GuiButtonInputOption)this.addButton((Widget)new GuiButtonInputOption(left, top + 84, "bs.flyBoost", this.onSettingClicked(() -> {
            if (ClientModManager.Feature.FLY_BOOST.isAvailable()) {
                BetterSprintingMod.config.update(ClientSettings.flySpeedBoost, value -> (value + 1) % 8);
            }
        })));
        this.btnFlyOnGround = (GuiButtonInputOption)this.addButton((Widget)new GuiButtonInputOption(left + 160, top + 84, "bs.flyOnGround", this.onSettingClicked(() -> {
            if (ClientModManager.Feature.FLY_ON_GROUND.isAvailable()) {
                BetterSprintingMod.config.update(ClientSettings.flyOnGround, value -> value == false);
            }
        })));
        this.btnDisableMod = (GuiButtonInputOption)this.addButton((Widget)new GuiButtonInputOption(left + 160, top + 108, "bs.disableMod", this.onSettingClicked(() -> {
            if (ClientModManager.canManuallyEnableMod()) {
                BetterSprintingMod.config.update(ClientSettings.disableMod, value -> value == false);
                this.updateButtonState();
            }
        })));
        this.btnAutoJump = (GuiButtonInputOption)this.addButton((Widget)new GuiButtonInputOption(left, top + 108, "bs.autoJump", this.onSettingClicked(() -> {
            GuiSprint.mc.field_71474_y.field_189989_R = !GuiSprint.mc.field_71474_y.field_189989_R;
            GuiSprint.mc.field_71474_y.func_74303_b();
        })));
        this.addButton((Widget)new GuiButton(this.width / 2 - 100, top + 168, this.parentScreen == null ? 98 : 200, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), this::onClickedDone));
        if (this.parentScreen == null) {
            this.addButton((Widget)new GuiButton(this.width / 2 + 2, top + 168, 98, I18n.func_135052_a((String)"options.controls", (Object[])new Object[0]), this::onClickedControls));
        }
        this.updateButtonState();
        this.updateButtonText();
    }

    private void updateButtonState() {
        for (Widget button : this.buttons) {
            KeyBinding binding;
            if (!(button instanceof GuiButtonInputBinding) || (binding = ((GuiButtonInputBinding)button).binding) != ClientModManager.keyBindSprintToggle && binding != ClientModManager.keyBindSneakToggle) continue;
            button.active = !ClientModManager.isModDisabled();
        }
        this.btnSprintMode.active = !ClientModManager.isModDisabled();
        this.btnDoubleTap.active = !ClientModManager.isModDisabled();
        this.btnAllDirs.active = ClientModManager.Feature.RUN_IN_ALL_DIRS.isAvailable();
        this.btnFlyBoost.active = ClientModManager.Feature.FLY_BOOST.isAvailable();
        this.btnFlyOnGround.active = ClientModManager.Feature.FLY_ON_GROUND.isAvailable();
        this.btnDisableMod.active = ClientModManager.canManuallyEnableMod();
    }

    private void updateButtonText() {
        this.btnSprintMode.setMessage(I18n.func_135052_a((String)(ClientModManager.isModDisabled() ? SprintKeyMode.TAP : (SprintKeyMode)((Object)ClientSettings.sprintKeyMode.get())).translationKey, (Object[])new Object[0]));
        this.btnDoubleTap.setTitleKey(ClientModManager.isModDisabled() ? "gui.unavailable" : ((Boolean)ClientSettings.enableDoubleTap.get() != false ? "gui.enabled" : "gui.disabled"));
        this.btnFlyBoost.setTitleKey(ClientModManager.Feature.FLY_BOOST.isAvailable() ? ((Integer)ClientSettings.flySpeedBoost.get() == 0 ? "gui.disabled" : (Integer)ClientSettings.flySpeedBoost.get() + 1 + "x") : "gui.unavailable");
        this.btnFlyOnGround.setTitleKey(ClientModManager.Feature.FLY_ON_GROUND.isAvailable() ? (((Boolean)ClientSettings.flyOnGround.get()).booleanValue() ? "gui.enabled" : "gui.disabled") : "gui.unavailable");
        this.btnAllDirs.setTitleKey(ClientModManager.Feature.RUN_IN_ALL_DIRS.isAvailable() ? (((Boolean)ClientSettings.enableAllDirs.get()).booleanValue() ? "gui.enabled" : "gui.disabled") : "gui.unavailable");
        this.btnDisableMod.setTitleKey(ClientModManager.isModDisabled() ? "gui.yes" : "gui.no");
        this.btnAutoJump.setTitleKey(GuiSprint.mc.field_71474_y.field_189989_R ? "gui.yes" : "gui.no");
    }

    private void onClickedControls() {
        ClientEventHandler.openedControlsFromSprintMenu = true;
        mc.func_147108_a((Screen)new ControlsScreen((Screen)this, GuiSprint.mc.field_71474_y));
        ClientEventHandler.openedControlsFromSprintMenu = false;
        BetterSprintingMod.config.save();
    }

    private void onClickedDone() {
        mc.func_147108_a(this.parentScreen);
        BetterSprintingMod.config.save();
    }

    private Runnable onSettingClicked(Runnable callback) {
        return () -> {
            callback.run();
            BetterSprintingMod.config.save();
            this.updateButtonText();
        };
    }

    private void onBindingClicked(GuiButtonInputBinding binding) {
        if (this.selectedBinding != null) {
            this.selectedBinding.setSelected(false);
        }
        this.selectedBinding = binding;
        this.selectedBinding.setSelected(true);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.selectedBinding != null) {
            this.selectedBinding.setBinding(InputMappings.Type.MOUSE.func_197944_a(button));
            this.onSelectedBindingUpdated();
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.selectedBinding != null) {
            if (keyCode == 256) {
                this.selectedBinding.setBinding(KeyModifier.NONE, InputMappings.field_197958_a);
            } else {
                this.selectedBinding.setBinding(KeyModifier.getActiveModifier(), InputMappings.func_197954_a((int)keyCode, (int)scanCode));
            }
            this.onSelectedBindingUpdated();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (this.selectedBinding != null) {
            this.selectedBinding.setBinding(KeyModifier.NONE, InputMappings.func_197954_a((int)keyCode, (int)scanCode));
            this.onSelectedBindingUpdated();
            return true;
        }
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    private void onSelectedBindingUpdated() {
        if (!this.selectedBinding.isSelected()) {
            this.selectedBinding = null;
        }
        for (Widget button : this.buttons) {
            if (!(button instanceof GuiButtonInputBinding)) continue;
            ((GuiButtonInputBinding)button).updateKeyBindingText();
        }
        ClientSettings.keyInfoSprintHold.readFrom(ClientModManager.keyBindSprintHold);
        ClientSettings.keyInfoSprintToggle.readFrom(ClientModManager.keyBindSprintToggle);
        ClientSettings.keyInfoSneakToggle.readFrom(ClientModManager.keyBindSneakToggle);
        ClientSettings.keyInfoOptionsMenu.readFrom(ClientModManager.keyBindOptionsMenu);
        KeyBinding.func_74508_b();
        GuiSprint.mc.field_71474_y.func_74303_b();
        BetterSprintingMod.config.save();
    }

    public void render(int mouseX, int mouseY, float partialTickTime) {
        int top = this.height / 6;
        int middle = this.width / 2;
        this.renderBackground();
        this.drawCenteredString(this.font, "Better Sprinting", middle, 20, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTickTime);
        int maxWidthLeft = 82;
        int maxWidthRight = 124;
        for (Widget button : this.buttons) {
            if (!(button instanceof GuiButtonCustomInput)) continue;
            this.drawButtonTitle(((GuiButtonCustomInput)button).getTitle(), button, button.x < middle ? 82 : 124);
            if (!button.isMouseOver((double)mouseX, (double)mouseY)) continue;
            String[] spl = ((GuiButtonCustomInput)button).getInfo();
            for (int line = 0; line < spl.length; ++line) {
                String string = spl[line];
                this.font.getClass();
                this.drawCenteredString(this.font, string, middle, top + 148 + (10 * line - 9 * spl.length / 2), -1);
            }
        }
    }

    private void drawButtonTitle(String title, Widget btn, int maxWidth) {
        int lines = this.font.func_78271_c(title, maxWidth).size();
        this.font.func_78279_b(title, btn.x + 76, btn.y + 7 - 5 * (lines - 1), maxWidth, -1);
    }
}

