/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client.player;

import chylex.bettersprinting.client.ClientModManager;
import chylex.bettersprinting.client.ClientSettings;
import chylex.bettersprinting.client.input.SprintKeyMode;
import chylex.bettersprinting.client.input.SprintState;
import chylex.bettersprinting.client.player.MovementController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerAbilities;
import net.minecraft.potion.Effects;
import net.minecraft.util.MovementInput;

final class PlayerLogicHandler {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final float flySpeedBase = 0.05f;
    private final ClientPlayerEntity player;
    private final PlayerAbilities abilities;
    private final MovementInput movementInput;
    private final MovementController movementController;
    private boolean wasMovingForward;
    private boolean wasSneaking;
    private SprintState sprinting;

    public PlayerLogicHandler(ClientPlayerEntity player) {
        this.player = player;
        this.abilities = player.field_71075_bZ;
        this.movementInput = player.field_71158_b;
        this.movementController = new MovementController(this.movementInput);
        this.sprinting = player.func_70051_ag() ? SprintState.DOUBLE_TAPPED_FORWARD : SprintState.INACTIVE;
    }

    public ClientPlayerEntity getPlayer() {
        return this.player;
    }

    public void resetState() {
        this.abilities.func_195931_a(0.05f);
    }

    public void updateMovementInput(boolean slowMovement) {
        if (ClientModManager.Feature.FLY_ON_GROUND.isEnabled()) {
            this.player.field_70122_E = false;
        }
        this.wasSneaking = this.movementInput.field_228350_h_;
        this.wasMovingForward = this.player.func_223110_ee();
        this.movementController.update(slowMovement);
    }

    public void updateSprinting() {
        int flySpeedBoostMultiplier;
        boolean shouldSprint;
        boolean isNotSneaking;
        boolean enoughHunger = (float)this.player.func_71024_bL().func_75116_a() > 6.0f || this.abilities.field_75101_c;
        boolean isSprintBlocked = this.player.func_184587_cr() || this.player.func_70644_a(Effects.field_76440_q);
        boolean isSprintHeld = ClientModManager.keyBindSprintHold.func_151470_d();
        boolean bl = isNotSneaking = !this.movementInput.field_228350_h_ || this.abilities.field_75100_b || this.player.func_203007_ba();
        if (((Boolean)ClientSettings.enableDoubleTap.get()).booleanValue() && (this.player.field_70122_E || this.player.func_204231_K()) && !this.wasSneaking && !this.wasMovingForward && this.player.func_223110_ee() && !this.sprinting.active() && enoughHunger && !isSprintBlocked) {
            if (this.player.field_71156_d <= 0 && !isSprintHeld) {
                this.player.field_71156_d = 7;
            } else {
                this.sprinting = SprintState.DOUBLE_TAPPED_FORWARD;
            }
        }
        if (!this.sprinting.active() && (!this.player.func_70090_H() || this.player.func_204231_K()) && this.player.func_223110_ee() && enoughHunger && !isSprintBlocked && isSprintHeld) {
            this.sprinting = ((SprintKeyMode)((Object)ClientSettings.sprintKeyMode.get())).sprintState;
        }
        if (this.movementController.isSprintToggled()) {
            this.sprinting = SprintState.TOGGLED;
        } else if (this.sprinting == SprintState.TOGGLED) {
            this.sprinting = SprintState.INACTIVE;
        }
        if (isSprintHeld) {
            if (this.sprinting != SprintState.TAPPING_SPRINT_KEY && this.sprinting != SprintState.TOGGLED) {
                this.sprinting = SprintState.HOLDING_SPRINT_KEY;
            }
        } else if (this.sprinting == SprintState.TAPPING_SPRINT_KEY) {
            this.sprinting = SprintState.TAPPED_SPRINT_KEY;
        } else if (this.sprinting == SprintState.HOLDING_SPRINT_KEY) {
            this.sprinting = SprintState.INACTIVE;
        }
        if (this.sprinting.active()) {
            boolean stopRunning;
            boolean isSlow = ClientModManager.Feature.RUN_IN_ALL_DIRS.isEnabled() ? !this.movementController.isMovingAnywhere() : !this.movementInput.func_223135_b();
            boolean isSlowOrHungry = isSlow || !enoughHunger;
            boolean bl2 = stopRunning = isSlowOrHungry || this.player.field_70123_F || this.player.func_70090_H() && !this.player.func_204231_K();
            if (this.player.func_203007_ba()) {
                if (!this.player.field_70122_E && !this.movementInput.field_228350_h_ && isSlowOrHungry || !this.player.func_70090_H()) {
                    this.sprinting = SprintState.INACTIVE;
                }
            } else if (stopRunning) {
                this.sprinting = SprintState.INACTIVE;
            }
        }
        boolean bl3 = shouldSprint = this.sprinting.active() && isNotSneaking && !isSprintBlocked && !this.abilities.field_75100_b;
        if (this.player.func_70051_ag() != shouldSprint) {
            this.player.func_70031_b(shouldSprint);
            if (!shouldSprint && this.sprinting == SprintState.TAPPED_SPRINT_KEY) {
                this.sprinting = SprintState.INACTIVE;
            }
        }
        if ((flySpeedBoostMultiplier = ((Integer)ClientSettings.flySpeedBoost.get()).intValue()) > 0) {
            if (ClientModManager.Feature.FLY_BOOST.isEnabled() && (isSprintHeld || this.movementController.isSprintToggled())) {
                this.abilities.func_195931_a(0.05f + 0.075f * (float)flySpeedBoostMultiplier);
            } else {
                this.abilities.func_195931_a(0.05f);
            }
        } else if (this.abilities.func_75093_a() > 0.05f) {
            this.abilities.func_195931_a(0.05f);
        }
    }

    public void updateFlight() {
        if (this.player.field_70122_E && this.abilities.field_75100_b && !PlayerLogicHandler.mc.field_71442_b.func_178887_k() && !ClientModManager.Feature.FLY_ON_GROUND.isEnabled()) {
            this.abilities.field_75100_b = false;
            this.player.func_71016_p();
        }
    }
}

