/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.server;

import chylex.bettersprinting.BetterSprintingMod;
import chylex.bettersprinting.server.ServerNetwork;
import chylex.bettersprinting.server.ServerSettings;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.DEDICATED_SERVER)
final class ServerCommandConfig {
    private static final String SETTING_SURVIVAL_FLY_BOOST = "survivalFlyBoost";
    private static final String SETTING_RUN_IN_ALL_DIRS = "runInAllDirs";
    private static final String[] SETTINGS_ALL = new String[]{"survivalFlyBoost", "runInAllDirs"};
    private static final String ARG_BOOLEAN = "true|false";
    private static final String ARG_SETTINGS = String.join((CharSequence)"|", SETTINGS_ALL);
    private static final SuggestionProvider<CommandSource> SUGGEST_SETTING = (context, builder) -> ISuggestionProvider.func_197008_a((String[])SETTINGS_ALL, (SuggestionsBuilder)builder);

    ServerCommandConfig() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"bettersprinting").requires(source -> source.func_197034_c(3));
        builder.executes(ServerCommandConfig::execHelp);
        builder.then(Commands.func_197057_a((String)"info").executes(ServerCommandConfig::execInfo));
        builder.then(Commands.func_197057_a((String)"disablemod").then(Commands.func_197056_a((String)ARG_BOOLEAN, (ArgumentType)BoolArgumentType.bool()).executes(ServerCommandConfig::execDisableMod)));
        builder.then(Commands.func_197057_a((String)"setting").then(Commands.func_197056_a((String)ARG_SETTINGS, (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_SETTING).then(Commands.func_197056_a((String)ARG_BOOLEAN, (ArgumentType)BoolArgumentType.bool()).executes(ServerCommandConfig::execSetting))));
        dispatcher.register(builder);
    }

    private static int execHelp(CommandContext<CommandSource> ctx) {
        CommandSource source = (CommandSource)ctx.getSource();
        ServerCommandConfig.sendMessage(source, TextFormatting.GREEN + "[Better Sprinting]");
        ServerCommandConfig.sendMessage(source, "/bettersprinting info");
        ServerCommandConfig.sendMessage(source, "/bettersprinting disablemod <true|false>");
        ServerCommandConfig.sendMessage(source, "/bettersprinting setting <" + ARG_SETTINGS + "> <" + ARG_BOOLEAN + ">");
        return 0;
    }

    private static int execInfo(CommandContext<CommandSource> ctx) {
        CommandSource source = (CommandSource)ctx.getSource();
        ServerCommandConfig.sendMessageTranslated(source, "bs.command.info", false);
        return 0;
    }

    private static int execDisableMod(CommandContext<CommandSource> ctx) {
        BetterSprintingMod.config.set(ServerSettings.disableClientMod, ctx.getArgument(ARG_BOOLEAN, Boolean.class));
        BetterSprintingMod.config.save();
        CommandSource source = (CommandSource)ctx.getSource();
        ServerCommandConfig.sendMessageTranslated(source, (Boolean)ServerSettings.disableClientMod.get() != false ? "bs.command.disableMod" : "bs.command.enableMod", true);
        ServerNetwork.sendToAll(source.func_197028_i().func_184103_al().func_181057_v(), ServerNetwork.writeDisableMod((Boolean)ServerSettings.disableClientMod.get()));
        return 0;
    }

    private static int execSetting(CommandContext<CommandSource> ctx) {
        String setting = (String)ctx.getArgument(ARG_SETTINGS, String.class);
        boolean value = (Boolean)ctx.getArgument(ARG_BOOLEAN, Boolean.class);
        CommandSource source = (CommandSource)ctx.getSource();
        if (setting.equalsIgnoreCase(SETTING_SURVIVAL_FLY_BOOST)) {
            BetterSprintingMod.config.set(ServerSettings.enableSurvivalFlyBoost, value);
            BetterSprintingMod.config.save();
            ServerCommandConfig.sendMessageTranslated(source, (Boolean)ServerSettings.enableSurvivalFlyBoost.get() != false ? "bs.command.enableFlyBoost" : "bs.command.disableFlyBoost", true);
            ServerNetwork.sendToAll(source.func_197028_i().func_184103_al().func_181057_v(), ServerNetwork.writeSettings((Boolean)ServerSettings.enableSurvivalFlyBoost.get(), (Boolean)ServerSettings.enableAllDirs.get()));
        } else if (setting.equalsIgnoreCase(SETTING_RUN_IN_ALL_DIRS)) {
            BetterSprintingMod.config.set(ServerSettings.enableAllDirs, value);
            BetterSprintingMod.config.save();
            ServerCommandConfig.sendMessageTranslated(source, (Boolean)ServerSettings.enableAllDirs.get() != false ? "bs.command.enableAllDirs" : "bs.command.disableAllDirs", true);
            ServerNetwork.sendToAll(source.func_197028_i().func_184103_al().func_181057_v(), ServerNetwork.writeSettings((Boolean)ServerSettings.enableSurvivalFlyBoost.get(), (Boolean)ServerSettings.enableAllDirs.get()));
        } else {
            ServerCommandConfig.execHelp(ctx);
        }
        return 0;
    }

    private static void sendMessage(CommandSource source, String text) {
        source.func_197030_a((ITextComponent)new StringTextComponent(text), false);
    }

    private static void sendMessageTranslated(CommandSource source, String translationName, boolean log) {
        Entity entity = source.func_197022_f();
        if (entity instanceof PlayerEntity && ServerNetwork.hasBetterSprinting((PlayerEntity)entity)) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(translationName, new Object[0]), log);
        } else {
            source.func_197030_a((ITextComponent)new StringTextComponent(LanguageMap.func_74808_a().func_74805_b(translationName)), log);
        }
    }
}

