/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.server;

import chylex.bettersprinting.server.ServerSettings;
import chylex.bettersprinting.system.PacketPipeline;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

@OnlyIn(value=Dist.DEDICATED_SERVER)
final class ServerNetwork
implements PacketPipeline.INetworkHandler {
    private static final Set<UUID> players = Collections.synchronizedSet(new HashSet());

    ServerNetwork() {
    }

    public static boolean hasBetterSprinting(PlayerEntity player) {
        return players.contains(player.func_110124_au());
    }

    public static void onDisconnected(PlayerEntity player) {
        players.remove(player.func_110124_au());
    }

    public static PacketBuffer writeSettings(boolean enableSurvivalFlyBoost, boolean enableAllDirs) {
        PacketBuffer buffer = PacketPipeline.buf();
        buffer.writeByte(0).writeBoolean(enableSurvivalFlyBoost).writeBoolean(enableAllDirs);
        return buffer;
    }

    public static PacketBuffer writeDisableMod(boolean disable) {
        PacketBuffer buffer = PacketPipeline.buf();
        buffer.writeByte(disable ? 1 : 2);
        return buffer;
    }

    private static void sendToPlayer(PlayerEntity player, PacketBuffer packet) {
        if (ServerNetwork.hasBetterSprinting(player)) {
            PacketPipeline.sendToPlayer(packet, player);
        }
    }

    public static void sendToAll(List<? extends PlayerEntity> players, PacketBuffer packet) {
        for (PlayerEntity playerEntity : players) {
            ServerNetwork.sendToPlayer(playerEntity, packet);
        }
    }

    @Override
    public void onPacket(LogicalSide side, ByteBuf data, PlayerEntity player) {
        players.add(player.func_110124_au());
        if (((Boolean)ServerSettings.disableClientMod.get()).booleanValue()) {
            ServerNetwork.sendToPlayer(player, ServerNetwork.writeDisableMod(true));
        }
        if (((Boolean)ServerSettings.enableSurvivalFlyBoost.get()).booleanValue() || ((Boolean)ServerSettings.enableAllDirs.get()).booleanValue()) {
            ServerNetwork.sendToPlayer(player, ServerNetwork.writeSettings((Boolean)ServerSettings.enableSurvivalFlyBoost.get(), (Boolean)ServerSettings.enableAllDirs.get()));
        }
    }
}

