/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client;

import chylex.bettersprinting.BetterSprintingNetwork;
import chylex.bettersprinting.client.ClientModManager;
import chylex.bettersprinting.client.ClientNetwork;
import chylex.bettersprinting.client.ClientSettings;
import chylex.bettersprinting.client.gui.GuiButton;
import chylex.bettersprinting.client.gui.GuiSprint;
import chylex.bettersprinting.client.player.IntegrityCheck;
import chylex.bettersprinting.client.player.LivingUpdate;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.OptionButton;
import net.minecraft.client.gui.widget.list.KeyBindingList;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public final class ClientEventHandler {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static boolean stopCheckingNewServer;
    public static boolean showDisableWarningWhenPossible;

    @SubscribeEvent
    public static void onPlayerLoginClient(PlayerEvent.PlayerLoggedInEvent e) {
        IntegrityCheck.register();
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinWorldEvent e) {
        if (stopCheckingNewServer || e.getEntity() != ClientEventHandler.mc.field_71439_g) {
            return;
        }
        stopCheckingNewServer = true;
        if (!mc.func_71387_A() && mc.func_147104_D() != null && !((Boolean)ClientSettings.disableMod.get()).booleanValue()) {
            BetterSprintingNetwork.sendToServer(ClientNetwork.writeModNotification(10));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onGuiOpen(GuiOpenEvent e) {
        if (stopCheckingNewServer && mc.func_175606_aa() == null) {
            ClientModManager.onDisconnectedFromServer();
            LivingUpdate.cleanup();
            IntegrityCheck.unregister();
            stopCheckingNewServer = false;
            showDisableWarningWhenPossible = false;
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END || ClientEventHandler.mc.field_71439_g == null) {
            return;
        }
        if (showDisableWarningWhenPossible) {
            ClientModManager.showChatMessage(I18n.func_135052_a((String)(ClientModManager.svDisableMod ? "bs.game.disabled" : "bs.game.reenabled"), (Object[])new Object[0]));
            showDisableWarningWhenPossible = false;
        }
        if (ClientModManager.keyBindOptionsMenu.func_151470_d()) {
            mc.func_147108_a((Screen)new GuiSprint(null));
        }
    }

    @SubscribeEvent
    public static void onGuiInitPost(GuiScreenEvent.InitGuiEvent.Post e) {
        Screen gui = e.getGui();
        if (gui instanceof ControlsScreen) {
            ControlsScreen controls = (ControlsScreen)gui;
            e.getWidgetList().stream().filter(btn -> btn instanceof OptionButton && ((OptionButton)btn).field_146137_o == AbstractOption.field_216719_z).findFirst().ifPresent(arg_0 -> ((GuiScreenEvent.InitGuiEvent.Post)e).removeWidget(arg_0));
            controls.func_231039_at__().stream().filter(widget -> widget instanceof KeyBindingList).map(widget -> ((KeyBindingList)widget).func_231039_at__()).findFirst().ifPresent(children -> children.removeIf(entry -> entry instanceof KeyBindingList.KeyEntry && ArrayUtils.contains((Object[])ClientModManager.keyBindings, (Object)((KeyBindingList.KeyEntry)entry).field_148282_b) || entry instanceof KeyBindingList.CategoryEntry && ((KeyBindingList.CategoryEntry)entry).field_148285_b.equals(ClientModManager.keyCategory)));
            if (!GuiSprint.openedControlsFromSprintMenu) {
                e.addWidget((Widget)new GuiButton(controls.field_230708_k_ / 2 + 5, 18, 150, "Better Sprinting", () -> mc.func_147108_a((Screen)new GuiSprint(ClientEventHandler.mc.field_71462_r))));
            }
        }
    }
}

