/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client;

import chylex.bettersprinting.BetterSprintingConfig;
import chylex.bettersprinting.BetterSprintingNetwork;
import chylex.bettersprinting.client.ClientEventHandler;
import chylex.bettersprinting.client.ClientModManager;
import chylex.bettersprinting.client.ClientNetwork;
import chylex.bettersprinting.client.ClientSettings;
import chylex.bettersprinting.client.gui.GuiSprint;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class ClientSetup {
    public static void setup() {
        BetterSprintingConfig.initialize(ModConfig.Type.CLIENT, ClientSettings.getSpec(), "client");
        BetterSprintingNetwork.initialize(new ClientNetwork());
        MinecraftForge.EVENT_BUS.register(ClientEventHandler.class);
        FMLJavaModLoadingContext.get().getModEventBus().register(ClientSetup.class);
        String modVersion = ModLoadingContext.get().getActiveContainer().getModInfo().getVersion().toString();
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> modVersion, (incomingVersion, isNetwork) -> true));
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, currentScreen) -> new GuiSprint((Screen)currentScreen));
    }

    @SubscribeEvent
    public static void onLoadComplete(FMLLoadCompleteEvent e) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.execute(() -> {
            GameSettings settings = mc.field_71474_y;
            settings.field_74324_K = (KeyBinding[])ArrayUtils.addAll((Object[])settings.field_74324_K, (Object[])new KeyBinding[]{ClientModManager.keyBindSprintToggle, ClientModManager.keyBindSneakToggle, ClientModManager.keyBindOptionsMenu});
            if (BetterSprintingConfig.isNew()) {
                ClientSettings.firstTimeSetup(settings);
            }
            ClientSettings.keyInfoSprintHold.writeInto(ClientModManager.keyBindSprintHold);
            ClientSettings.keyInfoSprintToggle.writeInto(ClientModManager.keyBindSprintToggle);
            ClientSettings.keyInfoSneakToggle.writeInto(ClientModManager.keyBindSneakToggle);
            ClientSettings.keyInfoOptionsMenu.writeInto(ClientModManager.keyBindOptionsMenu);
            KeyBinding.func_74508_b();
        });
    }
}

