/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client.gui;

import chylex.bettersprinting.client.gui.GuiButtonCustomInput;
import java.util.function.Consumer;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.KeyModifier;

@OnlyIn(value=Dist.CLIENT)
public final class GuiButtonInputBinding
extends GuiButtonCustomInput {
    private static final GameSettings settings = Minecraft.func_71410_x().field_71474_y;
    public final KeyBinding binding;
    private final Consumer<GuiButtonInputBinding> onClick;
    private boolean isSelected;

    public GuiButtonInputBinding(int x, int y, KeyBinding binding, Consumer<GuiButtonInputBinding> onClick) {
        super(x, y, binding == GuiButtonInputBinding.settings.field_151444_V ? "bs.sprint.hold" : binding.func_151464_g());
        this.binding = binding;
        this.onClick = onClick;
        this.updateKeyBindingText();
    }

    @Override
    public void func_230930_b_() {
        this.onClick.accept(this);
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
        this.updateKeyBindingText();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setBinding(InputMappings.Input input) {
        this.binding.func_197979_b(input);
        this.isSelected = false;
    }

    public void setBinding(KeyModifier modifier, InputMappings.Input input) {
        this.binding.setKeyModifierAndCode(modifier, input);
        this.isSelected &= KeyModifier.isKeyCodeModifier((InputMappings.Input)input) && modifier != KeyModifier.NONE;
    }

    public void updateKeyBindingText() {
        boolean hasConflict = false;
        boolean hasOnlyModifierConflict = true;
        if (!this.binding.func_197986_j()) {
            for (KeyBinding other : GuiButtonInputBinding.settings.field_74324_K) {
                if (this.binding == other || !this.binding.func_197983_b(other)) continue;
                hasConflict = true;
                hasOnlyModifierConflict &= this.binding.hasKeyCodeModifierConflict(other);
            }
        }
        if (this.isSelected) {
            this.func_238482_a_((ITextComponent)new StringTextComponent("> ").func_230529_a_((ITextComponent)this.binding.func_238171_j_().func_230532_e_().func_240699_a_(TextFormatting.YELLOW)).func_240702_b_(" <").func_240699_a_(TextFormatting.YELLOW));
        } else if (hasConflict) {
            this.func_238482_a_((ITextComponent)this.binding.func_238171_j_().func_230532_e_().func_240699_a_(hasOnlyModifierConflict ? TextFormatting.GOLD : TextFormatting.RED));
        } else {
            this.func_238482_a_(this.binding.func_238171_j_());
        }
    }
}

