/*
 * Decompiled with CFR 0.152.
 */
package bsm.javacheck.util;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public final class ForgeCompatibility {
    public static boolean tryLog(String data) {
        try {
            LogManager.getLogger((String)"JavaChecker").log(Level.ERROR, data);
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            try {
                Class relaunchLog = ForgeCompatibility.findFMLClass("relaunch", "FMLRelaunchLog");
                Method logSevere = ForgeCompatibility.findMethod(relaunchLog, "severe", String.class, Object[].class);
                if (logSevere != null) {
                    logSevere.invoke(null, data, new Object[0]);
                    return true;
                }
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
            return false;
        }
    }

    public static boolean tryResetModState() {
        try {
            Class cmm = ForgeCompatibility.findFMLClass("relauncher", "CoreModManager");
            Method getCoremods = ForgeCompatibility.findMethodAlt(cmm, new String[]{"getLoadedCoremods", "getIgnoredMods"}, new Class[0]);
            Method getReparsed = ForgeCompatibility.findMethodAlt(cmm, new String[]{"getReparseableCoremods"}, new Class[0]);
            if (getCoremods == null || getReparsed == null) {
                return false;
            }
            String myFile = ForgeCompatibility.getModFileName();
            ((List)getCoremods.invoke(null, new Object[0])).remove(myFile);
            ((List)getReparsed.invoke(null, new Object[0])).add(myFile);
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public static boolean isClientSide() {
        try {
            return Class.forName("net.minecraft.client.main.Main") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    private static Class findFMLClass(String classPackage, String className) {
        String searchTarget = classPackage.isEmpty() ? className : classPackage + "." + className;
        try {
            return Class.forName("cpw.mods.fml." + searchTarget);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName("net.minecraftforge.fml." + searchTarget);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    private static Method findMethod(Class cls, String methodName, Class ... params) {
        if (cls == null) {
            return null;
        }
        try {
            return cls.getMethod(methodName, params);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Method findMethodAlt(Class cls, String[] methodNames, Class ... params) {
        if (cls == null) {
            return null;
        }
        for (String methodName : methodNames) {
            try {
                return cls.getMethod(methodName, params);
            }
            catch (NoSuchMethodException e) {
            }
        }
        return null;
    }

    private static String getModFileName() throws URISyntaxException {
        return new File(ForgeCompatibility.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getName();
    }
}

