/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client.update;

import chylex.bettersprinting.client.ClientSettings;
import chylex.bettersprinting.client.update.VersionEntry;
import chylex.bettersprinting.system.Log;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.io.IOUtils;

public class UpdateThread
extends Thread {
    private static final String url = "https://raw.githubusercontent.com/chylex/Better-Sprinting/master/UpdateNotificationData.txt";
    private final String modVersion;
    private final String mcVersion;

    public UpdateThread(String modVersion) {
        this.modVersion = modVersion;
        this.mcVersion = "1.11.2";
        this.setPriority(1);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            Thread.sleep(1337L);
            JsonElement root = new JsonParser().parse(IOUtils.toString((URL)new URL(url), (Charset)StandardCharsets.UTF_8));
            ArrayList versionList = Lists.newArrayList();
            VersionEntry newestVersionForCurrentMC = null;
            int counter = -1;
            String buildId = "";
            boolean isInDev = true;
            String downloadURL = "https://bsprint.chylex.com/";
            Log.debug("Detecting Better Sprinting updates...", new Object[0]);
            for (Map.Entry entry : root.getAsJsonObject().entrySet()) {
                if (((String)entry.getKey()).charAt(0) == '~') {
                    if (!((String)entry.getKey()).substring(1).equals("URL")) continue;
                    downloadURL = ((JsonElement)entry.getValue()).getAsString();
                    continue;
                }
                versionList.add(new VersionEntry((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject()));
            }
            Collections.sort(versionList);
            for (VersionEntry version : versionList) {
                Log.debug("Reading update data: $0", version.versionIdentifier);
                if (version.isSupportedByMC(this.mcVersion)) {
                    if (newestVersionForCurrentMC == null) {
                        newestVersionForCurrentMC = version;
                    }
                    ++counter;
                }
                if (!version.modVersion.equals(this.modVersion)) continue;
                isInDev = false;
                buildId = version.buildId;
                break;
            }
            if (isInDev) {
                Log.debug("In-dev version used, notifications disabled.", new Object[0]);
                return;
            }
            Log.debug("Done.", new Object[0]);
            StringBuilder message = null;
            if (!buildId.isEmpty() && !buildId.equals("03-01-2017-0")) {
                message = new StringBuilder().append(TextFormatting.GREEN).append(" [Better Sprinting ").append(this.modVersion).append("]").append(TextFormatting.RESET).append("\n Caution, you are using a broken build that can cause critical crashes! Please, redownload or update the mod.");
            } else if (counter > 0 && newestVersionForCurrentMC != null && ClientSettings.enableUpdateNotifications) {
                message = new StringBuilder().append(TextFormatting.GREEN).append(" [Better Sprinting ").append(this.modVersion).append("]").append(TextFormatting.RESET).append("\n Found update ").append(TextFormatting.GREEN).append(newestVersionForCurrentMC.modVersionName).append(TextFormatting.RESET).append(" for MC ").append(this.mcVersion).append(", released ").append(newestVersionForCurrentMC.releaseDate).append(".\n You are currently ").append(counter).append(" version").append(counter == 1 ? "" : "s").append(" behind.");
            }
            if (message != null) {
                message.append("\n ").append(TextFormatting.GOLD).append("Click to download: ").append(downloadURL);
                for (String s : message.toString().split("\n")) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a(ForgeHooks.newChatWithLinks((String)s));
                }
            }
        }
        catch (UnknownHostException root) {
        }
        catch (Exception e) {
            Log.throwable(e, "Error detecting updates!", new Object[0]);
        }
    }
}

