/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client.gui;

import chylex.bettersprinting.BetterSprintingMod;
import chylex.bettersprinting.client.ClientModManager;
import chylex.bettersprinting.client.ClientSettings;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSprint
extends GuiScreen {
    private final GuiScreen parentScreen;
    private int buttonId = -1;
    private KeyBinding[] sprintBindings = new KeyBinding[]{ClientModManager.keyBindSprintHold, ClientModManager.keyBindSprintToggle, ClientModManager.keyBindSneakToggle, ClientModManager.keyBindOptionsMenu};
    private GuiButton btnDoubleTap;
    private GuiButton btnFlyBoost;
    private GuiButton btnAllDirs;
    private GuiButton btnDisableMod;

    public GuiSprint(GuiScreen parentScreen) {
        this.parentScreen = parentScreen;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        int left = this.getLeftColumnX();
        int top = this.field_146295_m / 6;
        for (int a = 0; a < this.sprintBindings.length; ++a) {
            GuiOptionButton btn = new GuiOptionButton(a, left + a % 2 * 160, top + 24 * (a >> 1), 70, 20, this.getKeyCodeString(a));
            this.field_146292_n.add(btn);
            if (a != 1 && a != 2 || !ClientModManager.isModDisabled()) continue;
            btn.field_146124_l = false;
        }
        this.btnDoubleTap = new GuiButton(199, left, top + 72, 70, 20, "");
        this.field_146292_n.add(this.btnDoubleTap);
        this.btnAllDirs = new GuiButton(198, left + 160, top + 72, 70, 20, "");
        this.field_146292_n.add(this.btnAllDirs);
        this.btnFlyBoost = new GuiButton(197, left, top + 96, 70, 20, "");
        this.field_146292_n.add(this.btnFlyBoost);
        this.btnDisableMod = new GuiButton(196, left + 160, top + 96, 70, 20, "");
        this.field_146292_n.add(this.btnDisableMod);
        if (ClientModManager.isModDisabled()) {
            this.btnDoubleTap.field_146124_l = false;
        }
        if (!ClientModManager.canRunInAllDirs(this.field_146297_k)) {
            this.btnAllDirs.field_146124_l = false;
        }
        if (!ClientModManager.canBoostFlying(this.field_146297_k)) {
            this.btnFlyBoost.field_146124_l = false;
        }
        if (this.field_146297_k.field_71439_g != null || this.field_146297_k.field_71441_e != null) {
            this.btnDisableMod.field_146124_l = false;
        }
        this.field_146292_n.add(new GuiButton(200, this.field_146294_l / 2 - 100, top + 168, this.parentScreen == null ? 98 : 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        if (this.parentScreen == null) {
            this.field_146292_n.add(new GuiButton(190, this.field_146294_l / 2 + 2, top + 168, 98, 20, I18n.func_135052_a((String)"options.controls", (Object[])new Object[0])));
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.btnDoubleTap.field_146126_j = I18n.func_135052_a((String)(ClientModManager.isModDisabled() ? "gui.unavailable" : (ClientSettings.enableDoubleTap ? "gui.enabled" : "gui.disabled")), (Object[])new Object[0]);
        this.btnFlyBoost.field_146126_j = I18n.func_135052_a((String)(ClientModManager.canBoostFlying(this.field_146297_k) ? (ClientSettings.flySpeedBoost == 0 ? "gui.disabled" : ClientSettings.flySpeedBoost + 1 + "x") : "gui.unavailable"), (Object[])new Object[0]);
        this.btnAllDirs.field_146126_j = I18n.func_135052_a((String)(ClientModManager.canRunInAllDirs(this.field_146297_k) ? (ClientSettings.enableAllDirs ? "gui.enabled" : "gui.disabled") : "gui.unavailable"), (Object[])new Object[0]);
        this.btnDisableMod.field_146126_j = I18n.func_135052_a((String)(ClientModManager.isModDisabled() ? "gui.yes" : "gui.no"), (Object[])new Object[0]);
    }

    protected void func_146284_a(GuiButton btn) {
        for (int a = 0; a < this.sprintBindings.length; ++a) {
            ((GuiButton)this.field_146292_n.get((int)a)).field_146126_j = this.getKeyCodeString(a);
        }
        switch (btn.field_146127_k) {
            case 190: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiControls((GuiScreen)this, this.field_146297_k.field_71474_y));
                break;
            }
            case 196: {
                if (!ClientModManager.inMenu(this.field_146297_k)) break;
                ClientSettings.disableMod = !ClientSettings.disableMod;
                this.func_73866_w_();
                break;
            }
            case 197: {
                if (!ClientModManager.canBoostFlying(this.field_146297_k) || (ClientSettings.flySpeedBoost = (byte)(ClientSettings.flySpeedBoost + 1)) != 8) break;
                ClientSettings.flySpeedBoost = 0;
                break;
            }
            case 198: {
                if (!ClientModManager.canRunInAllDirs(this.field_146297_k)) break;
                ClientSettings.enableAllDirs = !ClientSettings.enableAllDirs;
                break;
            }
            case 199: {
                if (ClientSettings.disableMod) break;
                ClientSettings.enableDoubleTap = !ClientSettings.enableDoubleTap;
                break;
            }
            case 200: {
                if (this.parentScreen == null) {
                    this.field_146297_k.func_71381_h();
                    break;
                }
                this.field_146297_k.func_147108_a(this.parentScreen);
                break;
            }
            default: {
                this.buttonId = btn.field_146127_k;
                btn.field_146126_j = "> " + GameSettings.func_74298_c((int)this.field_146297_k.field_71474_y.field_74324_K[btn.field_146127_k].func_151463_i()) + " <";
            }
        }
        ClientSettings.update(BetterSprintingMod.config);
        this.updateButtons();
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (!this.handleInput(button - 100)) {
            super.func_73864_a(mouseX, mouseY, button);
        }
    }

    protected void func_73869_a(char keyChar, int keyCode) throws IOException {
        if (!this.handleInput(keyCode)) {
            super.func_73869_a(keyChar, keyCode);
        }
    }

    private boolean handleInput(int keyId) {
        if (this.buttonId >= 0 && this.buttonId < 180) {
            this.sprintBindings[this.buttonId].func_151462_b(keyId == 1 ? 0 : keyId);
            ((GuiButton)this.field_146292_n.get((int)this.buttonId)).field_146126_j = this.getKeyCodeString(this.buttonId);
            this.buttonId = -1;
            KeyBinding.func_74508_b();
            ClientSettings.keyCodeSprintHold = ClientModManager.keyBindSprintHold.func_151463_i();
            ClientSettings.keyCodeSprintToggle = ClientModManager.keyBindSprintToggle.func_151463_i();
            ClientSettings.keyCodeSneakToggle = ClientModManager.keyBindSneakToggle.func_151463_i();
            ClientSettings.keyCodeOptionsMenu = ClientModManager.keyBindOptionsMenu.func_151463_i();
            ClientSettings.update(BetterSprintingMod.config);
            return true;
        }
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTickTime) {
        int a;
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, "Better Sprinting", this.field_146294_l / 2, 20, 0xFFFFFF);
        int left = this.getLeftColumnX();
        int top = this.field_146295_m / 6;
        int maxWidthLeft = 82;
        int maxWidthRight = 124;
        for (a = 0; a < this.sprintBindings.length; ++a) {
            boolean alreadyUsed = false;
            for (int b = 0; b < this.sprintBindings.length; ++b) {
                if (b == a || this.sprintBindings[a].func_151463_i() != this.sprintBindings[b].func_151463_i() || this.sprintBindings[a].func_151463_i() == 0) {
                    continue;
                }
                alreadyUsed = true;
                break;
            }
            for (KeyBinding binding : this.field_146297_k.field_71474_y.field_74324_K) {
                if (this.sprintBindings[a].func_151463_i() != binding.func_151463_i() || this.sprintBindings[a].func_151463_i() == 0) continue;
                alreadyUsed = true;
                break;
            }
            ((GuiButton)this.field_146292_n.get((int)a)).field_146126_j = this.buttonId == a ? "\u00a7f> \u00a7e??? \u00a7f<" : (alreadyUsed ? "\u00a7c" + this.getKeyCodeString(a) : this.getKeyCodeString(a));
            this.drawButtonTitle(I18n.func_135052_a((String)this.sprintBindings[a].func_151464_g(), (Object[])new Object[0]), (GuiButton)this.field_146292_n.get(a), a % 2 == 0 ? 82 : 124);
        }
        this.drawButtonTitle(I18n.func_135052_a((String)"bs.doubleTapping", (Object[])new Object[0]), this.btnDoubleTap, 82);
        this.drawButtonTitle(I18n.func_135052_a((String)"bs.runAllDirs", (Object[])new Object[0]), this.btnAllDirs, 124);
        this.drawButtonTitle(I18n.func_135052_a((String)"bs.flyBoost", (Object[])new Object[0]), this.btnFlyBoost, 82);
        this.drawButtonTitle(I18n.func_135052_a((String)"bs.disableMod", (Object[])new Object[0]), this.btnDisableMod, 124);
        for (a = 0; a < this.field_146292_n.size(); ++a) {
            String info;
            GuiButton btn = (GuiButton)this.field_146292_n.get(a);
            if (mouseX < btn.field_146128_h || mouseX > btn.field_146128_h + btn.func_146117_b() || mouseY < btn.field_146129_i || mouseY > btn.field_146129_i + 20) continue;
            switch (a) {
                case 0: {
                    info = "bs.sprint.hold.info";
                    break;
                }
                case 1: {
                    info = "bs.sprint.toggle.info";
                    break;
                }
                case 2: {
                    info = "bs.sneak.toggle.info";
                    break;
                }
                case 3: {
                    info = "bs.menu.info";
                    break;
                }
                case 4: {
                    info = "bs.doubleTapping.info";
                    break;
                }
                case 5: {
                    info = "bs.runAllDirs.info";
                    break;
                }
                case 6: {
                    info = "bs.flyBoost.info";
                    break;
                }
                case 7: {
                    info = "bs.disableMod.info";
                    break;
                }
                default: {
                    info = "";
                }
            }
            String[] spl = I18n.func_135052_a((String)info, (Object[])new Object[0]).split("#");
            for (int line = 0; line < spl.length; ++line) {
                this.func_73732_a(this.field_146289_q, spl[line], this.field_146294_l / 2, top + 143 + 10 * line - this.field_146289_q.field_78288_b * spl.length / 2, -1);
            }
            break;
        }
        super.func_73863_a(mouseX, mouseY, partialTickTime);
    }

    private int getLeftColumnX() {
        return this.field_146294_l / 2 - 155;
    }

    private String getKeyCodeString(int i) {
        return GameSettings.func_74298_c((int)this.sprintBindings[i].func_151463_i());
    }

    private void drawButtonTitle(String title, GuiButton btn, int maxWidth) {
        int lines = this.field_146289_q.func_78271_c(title, maxWidth).size();
        this.field_146289_q.func_78279_b(title, btn.field_146128_h + 76, btn.field_146129_i + 7 - 5 * (lines - 1), maxWidth, -1);
    }
}

