/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.block.BlockBOPDecoration;
import biomesoplenty.common.block.BlockBOPGrass;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPBamboo
extends BlockBOPDecoration {
    protected static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)15);

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public BlockBOPBamboo() {
        super(Material.field_151575_d);
        this.func_149711_c(0.2f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return direction == EnumFacing.UP && plantable.getPlant(world, pos.func_177972_a(direction)).func_177230_c() == this;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState state, World world, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        IBlockState groundState = world.func_180495_p(pos.func_177977_b());
        Block groundBlock = groundState.func_177230_c();
        if (groundBlock == this) {
            return true;
        }
        if (groundBlock == Blocks.field_150346_d || groundBlock == Blocks.field_150458_ak || groundBlock == BOPBlocks.farmland_0 || groundBlock == BOPBlocks.farmland_1 || groundBlock == BOPBlocks.dirt || groundBlock == Blocks.field_150349_c) {
            return true;
        }
        if (groundBlock instanceof BlockBOPGrass) {
            switch ((BlockBOPGrass.BOPGrassType)((Object)groundState.func_177229_b((IProperty)BlockBOPGrass.VARIANT))) {
                case LOAMY: 
                case SANDY: 
                case SILTY: {
                    return true;
                }
            }
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.checkAndDropBlock(worldIn, pos, state) && worldIn.func_175623_d(pos.func_177984_a())) {
            int age = (Integer)state.func_177229_b((IProperty)AGE);
            int treeHeight = 1;
            while (worldIn.func_180495_p(pos.func_177979_c(treeHeight)).func_177230_c() == this) {
                ++treeHeight;
            }
            if (treeHeight < 4) {
                if (age == 15) {
                    worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), 4);
                } else {
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)), 4);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }
}

