/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.core;

import biomesoplenty.api.item.BOPItems;
import biomesoplenty.api.particle.BOPParticleTypes;
import biomesoplenty.client.particle.EntityPixieTrailFX;
import biomesoplenty.client.particle.EntityTrailFX;
import biomesoplenty.client.texture.ForgeRedirectedResourcePack;
import biomesoplenty.common.block.IBOPBlock;
import biomesoplenty.common.config.MiscConfigurationHandler;
import biomesoplenty.common.entities.EntityButterfly;
import biomesoplenty.common.entities.EntityPixie;
import biomesoplenty.common.entities.EntitySnail;
import biomesoplenty.common.entities.EntityWasp;
import biomesoplenty.common.entities.RenderButterfly;
import biomesoplenty.common.entities.RenderPixie;
import biomesoplenty.common.entities.RenderSnail;
import biomesoplenty.common.entities.RenderWasp;
import biomesoplenty.common.entities.projectiles.EntityMudball;
import biomesoplenty.common.entities.projectiles.RenderMudball;
import biomesoplenty.common.fluids.BloodFluid;
import biomesoplenty.common.fluids.HoneyFluid;
import biomesoplenty.common.fluids.HotSpringWaterFluid;
import biomesoplenty.common.fluids.PoisonFluid;
import biomesoplenty.common.fluids.QuicksandFluid;
import biomesoplenty.common.item.IColoredItem;
import biomesoplenty.common.util.inventory.CreativeTabBOP;
import biomesoplenty.core.CommonProxy;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ClientProxy
extends CommonProxy {
    public static ResourceLocation[] bopTitlePanoramaPaths = new ResourceLocation[]{new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_0.png"), new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_1.png"), new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_2.png"), new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_3.png"), new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_4.png"), new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_5.png")};
    public static ResourceLocation particleTexturesLocation = new ResourceLocation("biomesoplenty:textures/particles/particles.png");
    public static ModelResourceLocation[] bucketModelLocations = new ModelResourceLocation[]{new ModelResourceLocation(new ResourceLocation("biomesoplenty", "blood_bucket"), "inventory"), new ModelResourceLocation(new ResourceLocation("biomesoplenty", "honey_bucket"), "inventory"), new ModelResourceLocation(new ResourceLocation("biomesoplenty", "hot_spring_water_bucket"), "inventory"), new ModelResourceLocation(new ResourceLocation("biomesoplenty", "poison_bucket"), "inventory"), new ModelResourceLocation(new ResourceLocation("biomesoplenty", "sand_bucket"), "inventory")};
    private static List<Block> blocksToColour = Lists.newArrayList();
    private static List<Item> itemsToColor = Lists.newArrayList();

    @Override
    public void registerRenderers() {
        if (MiscConfigurationHandler.overrideTitlePanorama) {
            GuiMainMenu.field_73978_o = bopTitlePanoramaPaths;
        }
        ClientProxy.registerEntityRenderer(EntityWasp.class, RenderWasp.class);
        ClientProxy.registerEntityRenderer(EntityPixie.class, RenderPixie.class);
        ClientProxy.registerEntityRenderer(EntitySnail.class, RenderSnail.class);
        ClientProxy.registerEntityRenderer(EntityButterfly.class, RenderButterfly.class);
        ClientProxy.registerEntityRenderer(EntityMudball.class, RenderMudball.class);
        ClientProxy.replaceForgeResources();
        ModelBakery.registerItemVariants((Item)ForgeModContainer.getInstance().universalBucket, (ResourceLocation[])bucketModelLocations);
    }

    @Override
    public void registerColouring() {
        for (Block block : blocksToColour) {
            IBOPBlock bopBlock = (IBOPBlock)block;
            if (bopBlock.getBlockColor() != null) {
                Minecraft.func_71410_x().func_184125_al().func_186722_a(bopBlock.getBlockColor(), new Block[]{block});
            }
            if (bopBlock.getItemColor() == null) continue;
            Minecraft.func_71410_x().getItemColors().func_186731_a(bopBlock.getItemColor(), new Block[]{block});
        }
        for (Item item : itemsToColor) {
            IColoredItem coloredItem = (IColoredItem)item;
            Minecraft.func_71410_x().getItemColors().func_186730_a(coloredItem.getItemColor(), new Item[]{item});
        }
    }

    @Override
    public void registerItemVariantModel(Item item, String name, int metadata) {
        if (item != null) {
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("biomesoplenty:" + name)});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation("BiomesOPlenty:" + name, "inventory"));
        }
    }

    @Override
    public void registerBlockSided(Block block) {
        if (block instanceof IBOPBlock) {
            IBOPBlock bopBlock = (IBOPBlock)block;
            IProperty[] nonRenderingProperties = bopBlock.getNonRenderingProperties();
            if (nonRenderingProperties != null) {
                StateMap custom_mapper = new StateMap.Builder().func_178442_a(nonRenderingProperties).func_178441_a();
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)custom_mapper);
            }
            if (bopBlock.getBlockColor() != null || bopBlock.getItemColor() != null) {
                blocksToColour.add(block);
            }
        }
    }

    @Override
    public void registerItemSided(Item item) {
        if (item.func_77614_k()) {
            ArrayList subItems = new ArrayList();
            item.func_150895_a(item, CreativeTabBOP.instance, subItems);
            for (ItemStack subItem : subItems) {
                String subItemName = item.func_77667_c(subItem);
                subItemName = subItemName.substring(subItemName.indexOf(".") + 1);
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("BiomesOPlenty", subItemName)});
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)subItem.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation("BiomesOPlenty:" + subItemName, "inventory"));
            }
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("BiomesOPlenty:" + item.delegate.name().func_110623_a(), "inventory"));
        }
        if (item instanceof IColoredItem && ((IColoredItem)item).getItemColor() != null) {
            itemsToColor.add(item);
        }
    }

    @Override
    public void registerFluidBlockRendering(Block block, String name) {
        final ModelResourceLocation fluidLocation = new ModelResourceLocation("BiomesOPlenty".toLowerCase() + ":fluids", name);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return fluidLocation;
            }
        });
    }

    @Override
    public void spawnParticle(BOPParticleTypes type, double x, double y, double z, Object ... info) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Particle entityFx = null;
        switch (type) {
            case PIXIETRAIL: {
                entityFx = new EntityPixieTrailFX((World)minecraft.field_71441_e, x, y, z, MathHelper.func_82716_a((Random)minecraft.field_71441_e.field_73012_v, (double)-0.03, (double)0.03), -0.02, MathHelper.func_82716_a((Random)minecraft.field_71441_e.field_73012_v, (double)-0.03, (double)0.03));
                break;
            }
            case MUD: {
                int itemId = Item.func_150891_b((Item)BOPItems.mudball);
                minecraft.field_71441_e.func_175688_a(EnumParticleTypes.ITEM_CRACK, x, y, z, MathHelper.func_82716_a((Random)minecraft.field_71441_e.field_73012_v, (double)-0.08, (double)0.08), MathHelper.func_82716_a((Random)minecraft.field_71441_e.field_73012_v, (double)-0.08, (double)0.08), MathHelper.func_82716_a((Random)minecraft.field_71441_e.field_73012_v, (double)-0.08, (double)0.08), new int[]{itemId});
                return;
            }
            case PLAYER_TRAIL: {
                if (info.length < 1) {
                    throw new RuntimeException("Missing argument for trail name!");
                }
                entityFx = new EntityTrailFX((World)minecraft.field_71441_e, x, y, z, (String)info[0]);
                break;
            }
        }
        if (entityFx != null) {
            minecraft.field_71452_i.func_78873_a(entityFx);
        }
    }

    @Override
    public void replaceBOPBucketTexture() {
        Map meshMapping = (Map)ReflectionHelper.getPrivateValue(ItemModelMesher.class, (Object)Minecraft.func_71410_x().func_175599_af().func_175037_a(), (String[])new String[]{"field_178092_c", "shapers"});
        final ItemMeshDefinition meshDefinition = (ItemMeshDefinition)meshMapping.get(ForgeModContainer.getInstance().universalBucket);
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a((Item)ForgeModContainer.getInstance().universalBucket, new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
                if (fluidStack != null && MiscConfigurationHandler.useBoPBucketTexture) {
                    if (fluidStack.getFluid() == BloodFluid.instance) {
                        return bucketModelLocations[0];
                    }
                    if (fluidStack.getFluid() == HoneyFluid.instance) {
                        return bucketModelLocations[1];
                    }
                    if (fluidStack.getFluid() == HotSpringWaterFluid.instance) {
                        return bucketModelLocations[2];
                    }
                    if (fluidStack.getFluid() == PoisonFluid.instance) {
                        return bucketModelLocations[3];
                    }
                    if (fluidStack.getFluid() == QuicksandFluid.instance) {
                        return bucketModelLocations[4];
                    }
                }
                return meshDefinition == null ? ModelDynBucket.LOCATION : meshDefinition.func_178113_a(stack);
            }
        });
    }

    private static void replaceForgeResources() {
        if (ForgeModContainer.replaceVanillaBucketModel && MiscConfigurationHandler.overrideForgeBuckets) {
            FMLClientHandler clientHandler = FMLClientHandler.instance();
            List resourcePackList = (List)ReflectionHelper.getPrivateValue(FMLClientHandler.class, (Object)clientHandler, (String[])new String[]{"resourcePackList"});
            Map resourcePackMap = (Map)ReflectionHelper.getPrivateValue(FMLClientHandler.class, (Object)clientHandler, (String[])new String[]{"resourcePackMap"});
            AbstractResourcePack resourcePack = (AbstractResourcePack)clientHandler.getResourcePackFor("Forge");
            resourcePackList.remove(resourcePack);
            resourcePackMap.remove("Forge");
            ForgeRedirectedResourcePack redirectedResourcePack = new ForgeRedirectedResourcePack(FMLCommonHandler.instance().findContainerFor((Object)"Forge"));
            resourcePackList.add(redirectedResourcePack);
            resourcePackMap.put("Forge", redirectedResourcePack);
        }
    }

    private static <E extends Entity> void registerEntityRenderer(Class<E> entityClass, Class<? extends Render<E>> renderClass) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, new EntityRenderFactory(renderClass));
    }

    private static class EntityRenderFactory<E extends Entity>
    implements IRenderFactory<E> {
        private Class<? extends Render<E>> renderClass;

        private EntityRenderFactory(Class<? extends Render<E>> renderClass) {
            this.renderClass = renderClass;
        }

        public Render<E> createRenderFor(RenderManager manager) {
            Render<E> renderer = null;
            try {
                renderer = this.renderClass.getConstructor(RenderManager.class).newInstance(manager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return renderer;
        }
    }
}

