/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.api.enums;

import biomesoplenty.api.generation.BOPGenLayer;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;

public enum BOPClimates {
    ICE_CAP(BiomeManager.BiomeType.ICY),
    TUNDRA(BiomeManager.BiomeType.ICY),
    BOREAL(BiomeManager.BiomeType.COOL),
    COLD_SWAMP(BiomeManager.BiomeType.COOL),
    WET_TEMPERATE(BiomeManager.BiomeType.WARM),
    DRY_TEMPERATE(BiomeManager.BiomeType.WARM),
    COOL_TEMPERATE(BiomeManager.BiomeType.COOL),
    WARM_TEMPERATE(BiomeManager.BiomeType.WARM),
    HOT_SWAMP(BiomeManager.BiomeType.WARM),
    TROPICAL(BiomeManager.BiomeType.DESERT),
    MEDITERANEAN(BiomeManager.BiomeType.WARM),
    SAVANNA(BiomeManager.BiomeType.DESERT),
    HOT_DESERT(BiomeManager.BiomeType.DESERT),
    WASTELAND(BiomeManager.BiomeType.DESERT),
    HELL(null);

    public final BiomeManager.BiomeType biomeType;
    private int totalBiomesWeight;
    private ArrayList<WeightedBiomeEntry> landBiomes = new ArrayList();
    private static BOPClimates[] values;
    private static final BOPClimates[] climateMapping;

    private BOPClimates(BiomeManager.BiomeType biomeType) {
        this.biomeType = biomeType;
    }

    public BOPClimates addBiome(int weight, Biome biome) {
        return this.addBiome(new WeightedBiomeEntry(weight, biome));
    }

    public BOPClimates addBiome(WeightedBiomeEntry biomeEntry) {
        this.totalBiomesWeight += biomeEntry.weight;
        this.landBiomes.add(biomeEntry);
        return this;
    }

    public Biome getRandomBiome(BOPGenLayer layer) {
        WeightedBiomeEntry item;
        int weight = layer.func_75902_a(this.totalBiomesWeight);
        Iterator<WeightedBiomeEntry> iterator = this.landBiomes.iterator();
        do {
            item = iterator.next();
        } while ((weight -= item.weight) >= 0);
        return item.biome;
    }

    public Biome getRandomOceanBiome(BOPGenLayer layer, boolean deep) {
        return deep ? Biomes.field_150575_M : Biomes.field_76771_b;
    }

    public static BOPClimates lookup(int i) {
        return values[i];
    }

    public static int[] getClimateMappingInts() {
        int[] out = new int[108];
        for (int i = 0; i < 108; ++i) {
            out[i] = climateMapping[i].ordinal();
        }
        return out;
    }

    public static void printWeights() {
        for (BOPClimates climate : BOPClimates.values()) {
            for (WeightedBiomeEntry entry : climate.landBiomes) {
                System.out.println(climate.name() + " " + entry.biome.func_185359_l() + " " + entry.weight);
            }
        }
    }

    static {
        ICE_CAP.addBiome(10, Biomes.field_76774_n);
        TUNDRA.addBiome(10, Biomes.field_150584_S).addBiome(10, Biomes.field_76770_e);
        BOREAL.addBiome(5, Biomes.field_150578_U).addBiome(5, Biomes.field_76770_e).addBiome(20, Biomes.field_76768_g);
        COLD_SWAMP.addBiome(5, Biomes.field_76780_h);
        WET_TEMPERATE.addBiome(20, Biomes.field_150585_R).addBiome(5, Biomes.field_76767_f);
        DRY_TEMPERATE.addBiome(5, Biomes.field_76772_c);
        COOL_TEMPERATE.addBiome(15, Biomes.field_76767_f).addBiome(10, Biomes.field_150583_P);
        WARM_TEMPERATE.addBiome(20, Biomes.field_76772_c).addBiome(5, Biomes.field_150583_P);
        HOT_SWAMP.addBiome(5, Biomes.field_76780_h);
        TROPICAL.addBiome(15, Biomes.field_76782_w);
        MEDITERANEAN.addBiome(5, Biomes.field_76772_c);
        SAVANNA.addBiome(20, Biomes.field_150588_X);
        HOT_DESERT.addBiome(30, Biomes.field_76769_d).addBiome(15, Biomes.field_150608_ab);
        WASTELAND.addBiome(1, Biomes.field_76769_d);
        HELL.addBiome(150, Biomes.field_76778_j);
        values = BOPClimates.values();
        climateMapping = new BOPClimates[]{TUNDRA, TUNDRA, TUNDRA, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, BOREAL, BOREAL, BOREAL, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, COLD_SWAMP, COLD_SWAMP, COLD_SWAMP, BOREAL, BOREAL, BOREAL, BOREAL, BOREAL, BOREAL, BOREAL, BOREAL, BOREAL, COLD_SWAMP, COLD_SWAMP, COLD_SWAMP, WET_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, COLD_SWAMP, WET_TEMPERATE, WET_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, WET_TEMPERATE, WET_TEMPERATE, WET_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, DRY_TEMPERATE, SAVANNA, SAVANNA, HOT_SWAMP, HOT_SWAMP, HOT_SWAMP, WET_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, MEDITERANEAN, MEDITERANEAN, SAVANNA, HOT_DESERT, HOT_DESERT, TROPICAL, TROPICAL, HOT_SWAMP, HOT_SWAMP, WET_TEMPERATE, WARM_TEMPERATE, MEDITERANEAN, MEDITERANEAN, SAVANNA, HOT_DESERT, HOT_DESERT, WASTELAND, TROPICAL, TROPICAL, TROPICAL, HOT_SWAMP, HOT_SWAMP, MEDITERANEAN, MEDITERANEAN, SAVANNA, HOT_DESERT, HOT_DESERT, WASTELAND, WASTELAND};
    }

    public static class WeightedBiomeEntry {
        public final int weight;
        public final Biome biome;

        public WeightedBiomeEntry(int weight, Biome biome) {
            this.weight = weight;
            this.biome = biome;
        }
    }
}

