/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.block.BlockBOPDirt;
import biomesoplenty.common.block.BlockBOPDoublePlant;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.block.BlockBOPMushroom;
import biomesoplenty.common.world.generator.GeneratorDoubleFlora;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWaterside;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorTaigaTree;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;

public class BiomeGenConiferousForest
extends BOPOverworldBiome {
    public BiomeGenConiferousForest() {
        super("coniferous_forest", new BOPBiome.PropsBuilder("Coniferous Forest").withGuiColour(5410656).withTemperature(Float.valueOf(0.45f)).withRainfall(Float.valueOf(0.5f)));
        this.terrainSettings.avgHeight(68.0).heightVariation(10.0, 20.0);
        this.canGenerateVillages = true;
        if (BOPBiomes.gravel_beach.isPresent()) {
            this.beachBiomeLocation = ((BOPOverworldBiome)BOPBiomes.gravel_beach.get()).getResourceLocation();
        }
        this.addWeight(BOPClimates.BOREAL, 10);
        this.field_76752_A = BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.LOAMY));
        this.field_76753_B = BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.LOAMY));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityWolf.class, 8, 4, 4));
        this.addGenerator("gravel", GeneratorStage.SAND_PASS2, ((GeneratorWaterside.Builder)((GeneratorWaterside.Builder)new GeneratorWaterside.Builder().amountPerChunk(4.0f)).maxRadius(7).with(Blocks.field_150351_n.func_176223_P())).create());
        GeneratorWeighted treeGenerator = new GeneratorWeighted(8.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("fir", 5, ((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)new GeneratorTaigaTree.Builder().log(BOPWoods.FIR)).leaves(BOPTrees.FIR)).minHeight(5)).maxHeight(28)).create());
        treeGenerator.add("mega_fir", 3, ((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)new GeneratorTaigaTree.Builder().log(BOPWoods.FIR)).leaves(BOPTrees.FIR)).minHeight(20)).maxHeight(40)).trunkWidth(2).create());
        this.addGenerator("shrubs", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(BOPPlants.SHRUB)).create());
        this.addGenerator("dead_leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.0f)).placeOn(BlockQueries.fertile)).with(BOPPlants.DEADLEAFPILE)).create());
        this.addGenerator("leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.3f)).placeOn(BlockQueries.fertile)).with(BOPPlants.LEAFPILE)).generationAttempts(64)).create());
        this.addGenerator("flax", GeneratorStage.FLOWERS, ((GeneratorDoubleFlora.Builder)new GeneratorDoubleFlora.Builder().amountPerChunk(0.2f)).with(BlockBOPDoublePlant.DoublePlantType.FLAX).create());
        this.addGenerator("berry_bushes", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(BOPPlants.BERRYBUSH)).create());
        this.addGenerator("poison_ivy", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).generationAttempts(16)).with(BOPPlants.POISONIVY)).create());
        this.addGenerator("bushes", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).with(BOPPlants.BUSH)).create());
        this.addGenerator("cattail", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(2.0f)).with(BOPPlants.CATTAIL)).create());
        this.addGenerator("double_cattail", GeneratorStage.FLOWERS, ((GeneratorDoubleFlora.Builder)new GeneratorDoubleFlora.Builder().amountPerChunk(1.0f)).with(BlockBOPDoublePlant.DoublePlantType.TALL_CATTAIL).create());
        this.addGenerator("flat_mushroom", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(BlockBOPMushroom.MushroomType.FLAT_MUSHROOM)).create());
        this.addGenerator("toadstools", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.3f)).with(BlockBOPMushroom.MushroomType.TOADSTOOL)).create());
        this.addGenerator("blue_milk_caps", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(BlockBOPMushroom.MushroomType.BLUE_MILK_CAP)).create());
        this.addGenerator("brown_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).with(Blocks.field_150338_P.func_176223_P())).create());
        this.addGenerator("red_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(Blocks.field_150337_Q.func_176223_P())).create());
        this.addGenerator("water_reeds", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.8f)).with(BOPPlants.REED)).generationAttempts(32)).create());
        GeneratorWeighted flowerGenerator = new GeneratorWeighted(0.5f);
        this.addGenerator("flowers", GeneratorStage.FLOWERS, flowerGenerator);
        flowerGenerator.add("bluebells", 1, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BOPFlowers.BLUEBELLS)).generationAttempts(128)).create());
        flowerGenerator.add("oxeye_daisy", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.OXEYE_DAISY)).create());
        flowerGenerator.add("dandelion", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.DANDELION)).create());
        flowerGenerator.add("poppy", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.POPPY)).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(1.6f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("tallgrass", 2, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).generationAttempts(128)).create());
        grassGenerator.add("shortgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("wheatgrass", 1, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.WHEATGRASS)).generationAttempts(128)).create());
        grassGenerator.add("dampgrass", 1, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.DAMPGRASS)).generationAttempts(128)).create());
        grassGenerator.add("fern", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.FERN)).create());
        this.addGenerator("amber", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.AMBER)).create());
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("glowshrooms");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("miners_delight");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.ROCK_FORMATIONS)) {
            this.removeGenerator("stone_formations");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GEMS)) {
            this.removeGenerator("amber");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.POISON_IVY)) {
            this.removeGenerator("poison_ivy");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLAX)) {
            this.removeGenerator("flax");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.BERRY_BUSHES)) {
            this.removeGenerator("berry_bushes");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("toadstools");
            this.removeGenerator("flat_mushroom");
            this.removeGenerator("blue_milk_caps");
            this.removeGenerator("portobellos");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.SOILS)) {
            this.field_76752_A = Blocks.field_150349_c.func_176223_P();
            this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FOLIAGE)) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.PLANTS)) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.WATER_PLANTS)) {
            this.removeGenerator("algae");
            this.removeGenerator("water_reeds");
            this.removeGenerator("medium_lily");
            this.removeGenerator("small_lily");
            this.removeGenerator("tiny_lily");
        }
        GeneratorWeighted treeGen = (GeneratorWeighted)this.getGenerator("trees");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.TREES)) {
            this.removeGenerator("trees");
            GeneratorWeighted treeGenerator = new GeneratorWeighted(8.0f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("fir", 5, ((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)new GeneratorTaigaTree.Builder().log(BlockPlanks.EnumType.SPRUCE)).leaves(BlockPlanks.EnumType.SPRUCE)).minHeight(5)).maxHeight(28)).create());
            treeGenerator.add("mega_fir", 3, ((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)new GeneratorTaigaTree.Builder().log(BlockPlanks.EnumType.SPRUCE)).leaves(BlockPlanks.EnumType.SPRUCE)).minHeight(20)).maxHeight(40)).trunkWidth(2).create());
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GRASSES)) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
        }
        GeneratorWeighted flowerGen = (GeneratorWeighted)this.getGenerator("flowers");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            flowerGen.removeGenerator("bluebells");
            flowerGen.removeGenerator("clover");
            flowerGen.removeGenerator("swampflower");
            flowerGen.removeGenerator("deathbloom");
            flowerGen.removeGenerator("glowflower");
            flowerGen.removeGenerator("blue_hydrangeas");
            flowerGen.removeGenerator("pink_daffodil");
            flowerGen.removeGenerator("white_anemones");
            flowerGen.removeGenerator("orange_cosmos");
            flowerGen.removeGenerator("wildflowers");
            flowerGen.removeGenerator("violet");
            flowerGen.removeGenerator("hibiscus");
            flowerGen.removeGenerator("goldenrods");
            flowerGen.removeGenerator("icy_irises");
            flowerGen.removeGenerator("wilted_lily");
            flowerGen.removeGenerator("lily_of_the_valley");
            this.removeGenerator("bromeliad");
        }
    }
}

