/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.entities.EntityButterfly;
import biomesoplenty.common.entities.EntitySnail;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorBigFlower;
import biomesoplenty.common.world.generator.GeneratorDoubleFlora;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorSplatter;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorBush;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;

public class BiomeGenFlowerIsland
extends BOPOverworldBiome {
    public BiomeGenFlowerIsland() {
        super("flower_island", new BOPBiome.PropsBuilder("Flower Island").withGuiColour(7656308).withTemperature(Float.valueOf(0.6f)).withRainfall(Float.valueOf(0.8f)));
        this.terrainSettings.avgHeight(70.0).heightVariation(10.0, 15.0).octaves(0.0, 0.0, 1.0, 1.0, 2.0, 2.0);
        this.field_76752_A = BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.DAISY));
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.canGenerateRivers = false;
        this.clearWeights();
        this.field_76761_J.clear();
        this.field_76762_K.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntitySnail.class, 6, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityButterfly.class, 6, 2, 4));
        IBlockPosQuery emptyGrass = BlockQuery.buildAnd().withAirAbove().states(this.field_76752_A).create();
        this.addGenerator("grass_splatter", GeneratorStage.SAND, ((GeneratorSplatter.Builder)((GeneratorSplatter.Builder)((GeneratorSplatter.Builder)new GeneratorSplatter.Builder().amountPerChunk(6.0f)).replace(emptyGrass)).with(Blocks.field_150349_c.func_176223_P())).create());
        GeneratorWeighted treeGenerator = new GeneratorWeighted(1.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("red_big_flowers", 1, new GeneratorBigFlower.Builder().flowerType(GeneratorBigFlower.BigFlowerType.RED).create());
        treeGenerator.add("yellow_big_flowers", 1, new GeneratorBigFlower.Builder().flowerType(GeneratorBigFlower.BigFlowerType.YELLOW).create());
        treeGenerator.add("oak_bush", 2, ((GeneratorBush.Builder)((GeneratorBush.Builder)new GeneratorBush.Builder().maxHeight(2)).altLeaves(BOPTrees.FLOWERING)).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(0.75f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("tallgrass", 4, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        grassGenerator.add("shortgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("dampgrass", 2, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.DAMPGRASS)).create());
        this.addGenerator("clover_patches", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).generationAttempts(128)).with(BOPPlants.CLOVERPATCH)).create());
        this.addGenerator("sprouts", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.5f)).with(BOPPlants.SPROUT)).create());
        GeneratorWeighted flowerGenerator = new GeneratorWeighted(4.0f);
        this.addGenerator("flowers", GeneratorStage.FLOWERS, flowerGenerator);
        flowerGenerator.add("dandelion", 3, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.DANDELION)).create());
        flowerGenerator.add("poppy", 5, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.POPPY)).create());
        flowerGenerator.add("white_anemones", 4, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BOPFlowers.WHITE_ANEMONE)).create());
        flowerGenerator.add("blue_hydrangeas", 2, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BOPFlowers.BLUE_HYDRANGEA)).create());
        flowerGenerator.add("sunflowers", 1, new GeneratorDoubleFlora.Builder().with(BlockDoublePlant.EnumPlantType.SUNFLOWER).create());
        flowerGenerator.add("oxeye_daisy", 2, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.OXEYE_DAISY)).create());
        flowerGenerator.add("rose", 2, new GeneratorDoubleFlora.Builder().with(BlockDoublePlant.EnumPlantType.ROSE).create());
        this.addGenerator("topaz", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.TOPAZ)).create());
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("glowshrooms");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("miners_delight");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.ROCK_FORMATIONS)) {
            this.removeGenerator("stone_formations");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GEMS)) {
            this.removeGenerator("topaz");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FOLIAGE)) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.PLANTS)) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.WATER_PLANTS)) {
            this.removeGenerator("algae");
            this.removeGenerator("water_reeds");
            this.removeGenerator("medium_lily");
            this.removeGenerator("small_lily");
            this.removeGenerator("tiny_lily");
        }
        GeneratorWeighted treeGen = (GeneratorWeighted)this.getGenerator("trees");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.TREES)) {
            this.removeGenerator("trees");
            GeneratorWeighted treeGenerator = new GeneratorWeighted(1.0f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("red_big_flowers", 1, new GeneratorBigFlower.Builder().flowerType(GeneratorBigFlower.BigFlowerType.RED).create());
            treeGenerator.add("yellow_big_flowers", 1, new GeneratorBigFlower.Builder().flowerType(GeneratorBigFlower.BigFlowerType.YELLOW).create());
            treeGenerator.add("oak_bush", 2, ((GeneratorBush.Builder)new GeneratorBush.Builder().maxHeight(2)).create());
        }
        GeneratorWeighted flowerGen = (GeneratorWeighted)this.getGenerator("flowers");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            flowerGen.removeGenerator("bluebells");
            flowerGen.removeGenerator("clover");
            flowerGen.removeGenerator("swampflower");
            flowerGen.removeGenerator("deathbloom");
            flowerGen.removeGenerator("glowflower");
            flowerGen.removeGenerator("blue_hydrangeas");
            flowerGen.removeGenerator("pink_daffodil");
            flowerGen.removeGenerator("white_anemones");
            flowerGen.removeGenerator("orange_cosmos");
            flowerGen.removeGenerator("wildflowers");
            flowerGen.removeGenerator("violet");
            flowerGen.removeGenerator("hibiscus");
            flowerGen.removeGenerator("goldenrods");
            flowerGen.removeGenerator("icy_irises");
            flowerGen.removeGenerator("wilted_lily");
            flowerGen.removeGenerator("lily_of_the_valley");
            flowerGen.removeGenerator("bromeliad");
            this.removeGenerator("bromeliad");
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GRASSES)) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
        }
    }

    public int func_180627_b(BlockPos pos) {
        return 7656308;
    }

    public int func_180625_c(BlockPos pos) {
        return 0x66E266;
    }
}

