/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.common.block.BlockBOPDecoration;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import biomesoplenty.common.item.ItemBOPSapling;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.VariantPagingHelper;
import biomesoplenty.common.world.generator.tree.GeneratorBasicTree;
import biomesoplenty.common.world.generator.tree.GeneratorBigTree;
import biomesoplenty.common.world.generator.tree.GeneratorBulbTree;
import biomesoplenty.common.world.generator.tree.GeneratorMahoganyTree;
import biomesoplenty.common.world.generator.tree.GeneratorMangroveTree;
import biomesoplenty.common.world.generator.tree.GeneratorPalmTree;
import biomesoplenty.common.world.generator.tree.GeneratorPineTree;
import biomesoplenty.common.world.generator.tree.GeneratorRedwoodTree;
import biomesoplenty.common.world.generator.tree.GeneratorTaigaTree;
import biomesoplenty.common.world.generator.tree.GeneratorTwigletTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPSapling
extends BlockBOPDecoration
implements IGrowable,
IPlantable {
    protected static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);
    public static VariantPagingHelper<BlockBOPSapling, BOPTrees> paging = new VariantPagingHelper(8, BOPTrees.class, BOPTrees.withSaplings);
    private static IProperty currentVariantProperty;
    public IProperty variantProperty;
    public static final PropertyInteger STAGE;

    public static void createAllPages() {
        int numPages = paging.getNumPages();
        for (int i = 0; i < numPages; ++i) {
            currentVariantProperty = paging.getVariantProperty(i);
            paging.addBlock(i, new BlockBOPSapling());
        }
    }

    protected BlockStateContainer func_180661_e() {
        this.variantProperty = currentVariantProperty;
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE, this.variantProperty});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPSapling.class;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{this.variantProperty};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return new IProperty[]{STAGE};
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((BOPTrees)((Object)state.func_177229_b(this.variantProperty))).func_176610_l() + "_sapling";
    }

    public BlockBOPSapling() {
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.variantProperty, (Comparable)((Object)paging.getVariant(this, meta & 7))).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta >> 3));
    }

    public int func_176201_c(IBlockState state) {
        BOPTrees tree = (BOPTrees)((Object)state.func_177229_b(this.variantProperty));
        return (Integer)state.func_177229_b((IProperty)STAGE) * 8 + paging.getIndex(tree);
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        switch ((BOPTrees)((Object)state.func_177229_b(this.variantProperty))) {
            case PALM: 
            case MANGROVE: {
                return BlockQueries.fertileOrSand.matches(world, pos.func_177977_b());
            }
        }
        return BlockQueries.fertile.matches(world, pos.func_177977_b());
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.func_176474_b(worldIn, rand, pos, state);
            }
        }
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state) & 7;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    protected WorldGenerator getSmallTreeGenerator(BOPTrees treeType) {
        switch (treeType) {
            case YELLOW_AUTUMN: {
                return ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().log(BlockPlanks.EnumType.BIRCH)).leaves(BOPTrees.YELLOW_AUTUMN)).minHeight(5)).maxHeight(8)).updateNeighbours(true)).create();
            }
            case ORANGE_AUTUMN: {
                return ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().log(BlockPlanks.EnumType.DARK_OAK)).leaves(BOPTrees.ORANGE_AUTUMN)).minHeight(5)).maxHeight(8)).updateNeighbours(true)).create();
            }
            case BAMBOO: {
                return ((GeneratorBulbTree.Builder)((GeneratorBulbTree.Builder)((GeneratorBulbTree.Builder)((GeneratorBulbTree.Builder)((GeneratorBulbTree.Builder)new GeneratorBulbTree.Builder().minHeight(6)).maxHeight(18)).log(BOPBlocks.bamboo.func_176223_P())).leaves(BOPTrees.BAMBOO)).updateNeighbours(true)).create();
            }
            case MAGIC: {
                return ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().log(BOPWoods.MAGIC)).leaves(BOPTrees.MAGIC)).updateNeighbours(true)).create();
            }
            case UMBRAN: {
                return ((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)new GeneratorTaigaTree.Builder().log(BOPWoods.UMBRAN)).leaves(BOPTrees.UMBRAN)).maxHeight(20)).updateNeighbours(true)).create();
            }
            case DEAD: {
                return ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().log(BlockPlanks.EnumType.OAK)).leaves(BOPTrees.DEAD)).minHeight(5)).maxHeight(8)).updateNeighbours(true)).create();
            }
            case FIR: {
                return ((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)new GeneratorTaigaTree.Builder().log(BOPWoods.FIR)).leaves(BOPTrees.FIR)).minHeight(5)).maxHeight(28)).updateNeighbours(true)).create();
            }
            case ETHEREAL: {
                return new WorldGenTrees(true);
            }
            case ORIGIN: {
                return ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().minHeight(5)).maxHeight(8)).leaves(BOPTrees.ORIGIN)).updateNeighbours(true)).create();
            }
            case PINK_CHERRY: {
                return ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().log(BOPWoods.CHERRY)).leaves(BOPTrees.PINK_CHERRY)).updateNeighbours(true)).create();
            }
            case WHITE_CHERRY: {
                return ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().log(BOPWoods.CHERRY)).leaves(BOPTrees.WHITE_CHERRY)).updateNeighbours(true)).create();
            }
            case MAPLE: {
                return ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().log(BlockPlanks.EnumType.OAK)).leaves(BOPTrees.MAPLE)).minHeight(5)).maxHeight(10)).updateNeighbours(true)).create();
            }
            case HELLBARK: {
                return ((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)new GeneratorTwigletTree.Builder().scatterYMethod(GeneratorUtils.ScatterYMethod.NETHER_SURFACE)).minHeight(2)).maxHeight(2)).log(BlockBOPLog.paging.getVariantState(BOPWoods.HELLBARK))).leaves(BlockBOPLeaves.paging.getVariantState(BOPTrees.HELLBARK))).create();
            }
            case FLOWERING: {
                return ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().altLeaves(BOPTrees.FLOWERING)).updateNeighbours(true)).create();
            }
            case JACARANDA: {
                return ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().minHeight(4)).maxHeight(7)).log(BOPWoods.JACARANDA)).leaves(BOPTrees.JACARANDA)).updateNeighbours(true)).create();
            }
            case SACRED_OAK: {
                return ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().log(BOPWoods.SACRED_OAK)).leaves(BlockBOPLeaves.paging.getVariantState(BOPTrees.SACRED_OAK).func_177226_a((IProperty)BlockOldLeaf.field_176237_a, (Comparable)Boolean.valueOf(false)))).minHeight(35)).maxHeight(45)).trunkWidth(2).foliageDensity(1.25).updateNeighbours(true)).create();
            }
            case MANGROVE: {
                return ((GeneratorMangroveTree.Builder)((GeneratorMangroveTree.Builder)new GeneratorMangroveTree.Builder().log(BOPWoods.MANGROVE)).leaves(BOPTrees.MANGROVE)).create();
            }
            case PALM: {
                return ((GeneratorPalmTree.Builder)((GeneratorPalmTree.Builder)((GeneratorPalmTree.Builder)new GeneratorPalmTree.Builder().log(BOPWoods.PALM)).leaves(BlockBOPLeaves.paging.getVariantState(BOPTrees.PALM).func_177226_a((IProperty)BlockOldLeaf.field_176237_a, (Comparable)Boolean.valueOf(false)))).updateNeighbours(true)).create();
            }
            case REDWOOD: {
                return new GeneratorRedwoodTree.Builder().create();
            }
            case WILLOW: {
                return ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().log(BOPWoods.WILLOW)).leaves(BlockBOPLeaves.paging.getVariantState(BOPTrees.WILLOW).func_177226_a((IProperty)BlockOldLeaf.field_176236_b, (Comparable)Boolean.valueOf(false)))).minHeight(8)).maxHeight(12)).maxLeavesRadius(2)).vine(BOPBlocks.willow_vine.func_176223_P())).leavesOffset(0)).updateNeighbours(true)).create();
            }
            case PINE: {
                return ((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)new GeneratorPineTree.Builder().minHeight(6)).maxHeight(18)).log(BOPWoods.PINE)).leaves(BOPTrees.PINE)).updateNeighbours(true)).create();
            }
            case MAHOGANY: {
                return ((GeneratorMahoganyTree.Builder)new GeneratorMahoganyTree.Builder().updateNeighbours(true)).create();
            }
            case EBONY: {
                return ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().log(BOPWoods.EBONY)).leaves(BOPTrees.EBONY)).minHeight(4)).maxHeight(10)).foliageHeight(1).updateNeighbours(true)).create();
            }
            case EUCALYPTUS: {
                return ((GeneratorBulbTree.Builder)((GeneratorBulbTree.Builder)((GeneratorBulbTree.Builder)((GeneratorBulbTree.Builder)((GeneratorBulbTree.Builder)new GeneratorBulbTree.Builder().minHeight(15)).maxHeight(30)).log(BOPWoods.EUCALYPTUS)).leaves(BOPTrees.EUCALYPTUS)).updateNeighbours(true)).create();
            }
        }
        return null;
    }

    protected WorldGenerator getBigTreeGenerator(BOPTrees treeType) {
        return null;
    }

    protected WorldGenerator getMegaTreeGenerator(BOPTrees treeType) {
        return null;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            this.generateTree(worldIn, pos, state, rand);
        }
    }

    public boolean thisSaplingHere(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == this;
    }

    public boolean generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return false;
        }
        BOPTrees treeType = (BOPTrees)((Object)state.func_177229_b(this.variantProperty));
        WorldGenerator smallTreeGenerator = this.getSmallTreeGenerator(treeType);
        WorldGenerator bigTreeGenerator = this.getBigTreeGenerator(treeType);
        WorldGenerator megaTreeGenerator = this.getMegaTreeGenerator(treeType);
        if (megaTreeGenerator != null) {
            for (int i = 0; i >= -1; --i) {
                for (int j = 0; j >= -1; --j) {
                    if (!this.thisSaplingHere(worldIn, pos.func_177982_a(i, 0, j)) || !this.thisSaplingHere(worldIn, pos.func_177982_a(i + 1, 0, j)) || !this.thisSaplingHere(worldIn, pos.func_177982_a(i, 0, j + 1)) || !this.thisSaplingHere(worldIn, pos.func_177982_a(i + 1, 0, j + 1)) || !this.generateMegaTree(worldIn, pos.func_177982_a(i, 0, j), state, rand, megaTreeGenerator)) continue;
                    return true;
                }
            }
        }
        if (bigTreeGenerator != null && rand.nextInt(10) == 0 && this.generateSmallOrBigTree(worldIn, pos, state, rand, bigTreeGenerator)) {
            return true;
        }
        return smallTreeGenerator != null && this.generateSmallOrBigTree(worldIn, pos, state, rand, smallTreeGenerator);
    }

    public boolean generateSmallOrBigTree(World worldIn, BlockPos pos, IBlockState state, Random rand, WorldGenerator generator) {
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 4);
        boolean success = generator.func_180709_b(worldIn, rand, pos);
        if (!success) {
            worldIn.func_180501_a(pos, state, 4);
        }
        return success;
    }

    public boolean generateMegaTree(World worldIn, BlockPos pos, IBlockState state, Random rand, WorldGenerator generator) {
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        worldIn.func_180501_a(pos, air, 4);
        worldIn.func_180501_a(pos.func_177982_a(1, 0, 0), air, 4);
        worldIn.func_180501_a(pos.func_177982_a(0, 0, 1), air, 4);
        worldIn.func_180501_a(pos.func_177982_a(1, 0, 1), air, 4);
        boolean success = generator.func_180709_b(worldIn, rand, pos);
        if (!success) {
            worldIn.func_180501_a(pos, air, 4);
            worldIn.func_180501_a(pos.func_177982_a(1, 0, 0), state, 4);
            worldIn.func_180501_a(pos.func_177982_a(0, 0, 1), state, 4);
            worldIn.func_180501_a(pos.func_177982_a(1, 0, 1), state, 4);
        }
        return success;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    static {
        STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    }
}

