/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.common.block.BlockBOPDecoration;
import biomesoplenty.common.block.IBOPBlock;
import biomesoplenty.common.item.ItemBOPBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPStoneFormations
extends BlockBOPDecoration
implements IBOPBlock {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", FormationType.class);
    public static final PropertyEnum POSITION = PropertyEnum.func_177709_a((String)"position", FormationPosition.class);

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POSITION, VARIANT});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPBlock.class;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{VARIANT};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((FormationType)((Object)state.func_177229_b((IProperty)VARIANT))).func_176610_l();
    }

    public BlockBOPStoneFormations() {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POSITION, (Comparable)((Object)FormationPosition.STALAGMITE_SMALL)).func_177226_a((IProperty)VARIANT, (Comparable)((Object)FormationType.STONE_FORMATION)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean formationAbove = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
        boolean formationBelow = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        boolean groundAbove = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150348_b;
        boolean groundBelow = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150348_b;
        FormationPosition position = FormationPosition.STALAGMITE_SMALL;
        if (groundAbove && !formationAbove) {
            if (groundBelow && !formationBelow) {
                position = FormationPosition.STAL_SINGLE;
            } else if (!groundBelow) {
                position = formationBelow ? FormationPosition.STALACTITE_MEDIUM : FormationPosition.STALACTITE_SMALL;
            }
        } else if (!groundAbove) {
            if (!groundBelow) {
                if (formationAbove) {
                    position = formationBelow ? FormationPosition.STAL_CONNECTOR : FormationPosition.STALACTITE_BOTTOM;
                } else if (formationBelow) {
                    position = FormationPosition.STALAGMITE_TOP;
                }
            } else if (!formationAbove && !formationBelow) {
                position = FormationPosition.STALAGMITE_SMALL;
            } else if (formationAbove && !formationBelow) {
                position = FormationPosition.STALAGMITE_MEDIUM;
            }
        }
        return state.func_177226_a((IProperty)POSITION, (Comparable)((Object)position));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)FormationType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((FormationType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, 1.0, (double)0.9f);
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150348_b || world.func_180495_p(pos.func_177977_b()) == state || world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150348_b || world.func_180495_p(pos.func_177984_a()) == state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    public static enum FormationPosition implements IStringSerializable
    {
        STALAGMITE_SMALL,
        STALACTITE_SMALL,
        STAL_SINGLE,
        STAL_CONNECTOR,
        STALAGMITE_MEDIUM,
        STALACTITE_MEDIUM,
        STALAGMITE_TOP,
        STALACTITE_BOTTOM;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }

    public static enum FormationType implements IStringSerializable
    {
        STONE_FORMATION;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

