/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.inventory;

import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.item.ItemFlowerBasket;
import biomesoplenty.common.util.NBTUtil;
import biomesoplenty.common.util.entity.PlayerUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryFlowerBasket
extends InventoryBasic {
    public static final int INVENTORY_ROWS = 2;
    public static final int INVENTORY_COLUMNS = 9;
    private EntityPlayer player;
    private ItemStack ownerStack = ItemStack.field_190927_a;

    public InventoryFlowerBasket(@Nonnull ItemStack ownerStack, EntityPlayer player) {
        super("container.flower_basket", false, 18);
        this.player = player;
        ItemStack basketStack = ownerStack;
        if (basketStack.func_190926_b()) {
            basketStack = player.func_184586_b(PlayerUtil.getHandForItemAndMeta(player, BOPItems.flower_basket, 0));
        } else {
            this.ownerStack = basketStack;
        }
        NBTTagCompound invData = NBTUtil.getOrCreateStackNBT(basketStack);
        this.readFromNBT(invData);
    }

    public InventoryFlowerBasket(EntityPlayer player) {
        this(ItemStack.field_190927_a, player);
    }

    public void func_70296_d() {
        ItemStack basketStack = this.getBasketStack();
        if (!basketStack.func_190926_b()) {
            NBTTagCompound currentData = new NBTTagCompound();
            this.writeToNBT(currentData);
            basketStack.func_77982_d(currentData);
        }
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagList itemsList = compound.func_150295_c("Items", 10);
        this.func_174888_l();
        for (int index = 0; index < itemsList.func_74745_c(); ++index) {
            NBTTagCompound itemTag = itemsList.func_150305_b(index);
            byte slotIndex = itemTag.func_74771_c("Slot");
            if (slotIndex < 0 || slotIndex >= this.func_70302_i_()) continue;
            this.func_70299_a(slotIndex, new ItemStack(itemTag));
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.func_110133_a(compound.func_74779_i("CustomName"));
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList itemsList = new NBTTagList();
        for (int slotIndex = 0; slotIndex < this.func_70302_i_(); ++slotIndex) {
            if (this.func_70301_a(slotIndex).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)slotIndex);
            this.func_70301_a(slotIndex).func_77955_b(itemTag);
            itemsList.func_74742_a((NBTBase)itemTag);
        }
        compound.func_74782_a("Items", (NBTBase)itemsList);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.func_70005_c_());
        }
        compound.func_74757_a("BasketOpen", ItemFlowerBasket.isBasketOpen(this.getBasketStack()));
    }

    @Nonnull
    private ItemStack getBasketStack() {
        return !this.ownerStack.func_190926_b() ? this.ownerStack : ItemFlowerBasket.findOpenBasketStack(this.player);
    }
}

