/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator.tree;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.world.generator.tree.GeneratorTreeBase;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GeneratorPalmTree
extends GeneratorTreeBase {
    public GeneratorPalmTree(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, IBlockState altLeaves, int minHeight, int maxHeight, GeneratorUtils.ScatterYMethod scatterYMethod) {
        super(amountPerChunk, placeOn, replace, log, leaves, vine, hanging, trunkFruit, altLeaves, minHeight, maxHeight, scatterYMethod);
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        while (pos.func_177956_o() > 1 && world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().isLeaves(world.func_180495_p(pos), (IBlockAccess)world, pos)) {
            pos = pos.func_177977_b();
        }
        if (!this.placeOn.matches(world, pos)) {
            return false;
        }
        int height = GeneratorUtils.nextIntBetween(random, this.minHeight, this.maxHeight);
        int leavesRadius = 2;
        int heightMinusTop = height - leavesRadius - 1;
        boolean slant = true;
        EnumFacing direction = EnumFacing.func_176741_a((Random)random);
        if (direction == EnumFacing.DOWN || direction == EnumFacing.UP) {
            slant = false;
        }
        double baseSlant = (double)random.nextInt(35) / 100.0;
        double slantMultiplier = 1.3;
        if (height < 8) {
            return false;
        }
        if (!this.checkSpace(world, pos = pos.func_177984_a(), height, 1)) {
            return false;
        }
        double slantOffset = baseSlant;
        for (int step = 0; step <= heightMinusTop; ++step) {
            BlockPos offsetPos = pos.func_177981_b(step);
            if (slant) {
                offsetPos = pos.func_177981_b(step).func_177967_a(direction, (int)Math.floor(slantOffset));
            }
            if (step == heightMinusTop) {
                this.setLog(world, offsetPos);
                this.generateLeavesTop(world, offsetPos, leavesRadius);
                break;
            }
            this.setLog(world, offsetPos);
            slantOffset *= slantMultiplier;
        }
        return true;
    }

    public boolean checkSpace(World world, BlockPos pos, int height, int radius) {
        for (int y = 0; y <= height; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeavesTop(World world, BlockPos pos, int maxRadius) {
        this.setLeaves(world, pos.func_177982_a(2, -1, 0));
        this.setLeaves(world, pos.func_177982_a(-2, -1, 0));
        this.setLeaves(world, pos.func_177982_a(0, -1, 2));
        this.setLeaves(world, pos.func_177982_a(0, -1, -2));
        this.setLeaves(world, pos.func_177982_a(1, 0, 0));
        this.setLeaves(world, pos.func_177982_a(-1, 0, 0));
        this.setLeaves(world, pos.func_177982_a(0, 0, 1));
        this.setLeaves(world, pos.func_177982_a(0, 0, -1));
        this.setLeaves(world, pos.func_177982_a(2, 0, 2));
        this.setLeaves(world, pos.func_177982_a(-2, 0, -2));
        this.setLeaves(world, pos.func_177982_a(2, 0, -2));
        this.setLeaves(world, pos.func_177982_a(-2, 0, 2));
        this.setLeaves(world, pos.func_177982_a(1, 1, -1));
        this.setLeaves(world, pos.func_177982_a(-1, 1, 1));
        this.setLeaves(world, pos.func_177982_a(1, 1, 1));
        this.setLeaves(world, pos.func_177982_a(-1, 1, -1));
        this.setLeaves(world, pos.func_177982_a(0, 1, 0));
        this.setLeaves(world, pos.func_177982_a(2, 2, 0));
        this.setLeaves(world, pos.func_177982_a(-2, 2, 0));
        this.setLeaves(world, pos.func_177982_a(0, 2, 2));
        this.setLeaves(world, pos.func_177982_a(0, 2, -2));
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.minHeight = conf.getInt("minHeight", this.minHeight);
        this.maxHeight = conf.getInt("minHeight", this.maxHeight);
        this.placeOn = conf.getBlockPosQuery("placeOn", this.placeOn);
        this.replace = conf.getBlockPosQuery("replace", this.replace);
        this.log = conf.getBlockState("logState", this.log);
        this.leaves = conf.getBlockState("leavesState", this.leaves);
    }

    public static class Builder
    extends GeneratorTreeBase.InnerBuilder<Builder, GeneratorPalmTree>
    implements IGenerator.IGeneratorBuilder<GeneratorPalmTree> {
        public Builder() {
            this.amountPerChunk = 1.0f;
            this.minHeight = 10;
            this.maxHeight = 14;
            this.placeOn = BlockQueries.fertileOrSand;
            this.replace = BlockQueries.airOrLeaves;
            this.log = Blocks.field_150364_r.func_176223_P();
            this.leaves = Blocks.field_150362_t.func_176223_P();
            this.vine = null;
            this.hanging = null;
            this.trunkFruit = null;
            this.altLeaves = null;
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.AT_SURFACE;
        }

        @Override
        public GeneratorPalmTree create() {
            return new GeneratorPalmTree(this.amountPerChunk, this.placeOn, this.replace, this.log, this.leaves, this.vine, this.hanging, this.trunkFruit, this.altLeaves, this.minHeight, this.maxHeight, this.scatterYMethod);
        }
    }
}

