/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.client.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeMapColours {
    public static final boolean RANDOM_COLOURS = false;
    public static Map<Integer, Integer> biomeColours = new HashMap<Integer, Integer>();
    public static Random rand = new Random(50L);

    public static int getBiomeMapColour(int biomeId) {
        if (biomeColours.containsKey(biomeId)) {
            return biomeColours.get(biomeId);
        }
        int colour = BiomeMapColours.getBiomeMapColourRaw(Biome.func_180276_a((int)biomeId, null));
        biomeColours.put(biomeId, colour);
        return colour;
    }

    public static int getBiomeMapColourRaw(Biome biome) {
        boolean treebased = false;
        int colour = BiomeMapColours.getTopColour(biome);
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            colour = BiomeMapColours.blend(biome.func_180625_c(BlockPos.field_177992_a), -16027648, 0.35);
            treebased = true;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.LUSH) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            colour = BiomeMapColours.blend(colour, -16027648, Math.min(0.25, 0.00625));
            colour = BiomeMapColours.brightness(colour, 1.0 - Math.min(0.1, 0.00375));
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                treebased = true;
            }
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            colour = BiomeMapColours.blend(colour, -12221697, 0.7);
        }
        if ((double)biome.func_185355_j() > 0.0) {
            double mod = Math.min((double)biome.func_185355_j() * 0.2 + 1.0, 1.35);
            colour = BiomeMapColours.brightness(colour, mod);
        } else if ((double)biome.func_185355_j() <= -1.2) {
            colour = BiomeMapColours.brightness(colour, 0.9);
        }
        if (treebased) {
            colour = BiomeMapColours.temptint(colour, biome.func_180626_a(new BlockPos(0, 64, 0)));
        }
        if (biome.func_185353_n() < 0.15f) {
            colour = BiomeMapColours.blend(colour, -1, 0.5);
            colour = BiomeMapColours.brightness(colour, 1.2);
        }
        return colour | 0xFF000000;
    }

    public static int getTopColour(Biome biome) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 64, 0);
        return BiomeMapColours.getBiomeBlockColourForCoords(biome, (BlockPos)pos);
    }

    public static int getBiomeBlockColourForCoords(Biome biome, BlockPos pos) {
        int colour;
        IBlockState topBlock = biome.func_205401_q().func_205549_a().func_204108_a();
        if (topBlock == Blocks.field_150349_c.func_176223_P()) {
            colour = topBlock.func_185909_g(null, (BlockPos)pos).field_76291_p | 0xFF000000;
            int tint = biome.func_180627_b(pos) | 0xFF000000;
            colour = BiomeMapColours.blend(colour, tint, 0.75);
        } else {
            colour = BiomeMapColours.getBlockColourRaw(topBlock);
        }
        return colour;
    }

    public static int getBlockColourRaw(IBlockState block) {
        int colour;
        Minecraft mc = Minecraft.func_71410_x();
        BlockRendererDispatcher brd = mc.func_175602_ab();
        BlockModelShapes shapes = brd.func_175023_a();
        BlockColors colours = mc.func_184125_al();
        int fallback = colour = block.func_185909_g(null, null).field_76291_p | 0xFF000000;
        if (block != Blocks.field_150349_c.func_176223_P()) {
            try {
                IBakedModel topmodel = shapes.func_178125_b(block);
                List topquads = topmodel.func_200117_a(block, EnumFacing.UP, rand);
                for (BakedQuad quad : topquads) {
                    colour = block.func_185909_g(null, null).field_76291_p | 0xFF000000;
                    if (!quad.func_178212_b()) continue;
                    int tint = colours.func_186724_a(block, null, null, quad.func_178211_c()) | 0xFF000000;
                    colour = BiomeMapColours.blend(colour, tint, 0.75);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                colour = fallback;
            }
        }
        return block.func_185909_g(null, null).field_76291_p | 0xFF000000;
    }

    public static int intAverage(int a, int b) {
        return (int)((((long)(a ^ b) & 0xFFFEFEFEL) >> 1) + (long)(a & b));
    }

    public static int blend(int a, int b, double mix) {
        if (mix == 0.0) {
            return a;
        }
        if (mix == 1.0) {
            return b;
        }
        if (mix == 0.5) {
            return BiomeMapColours.intAverage(a, b);
        }
        int ar = (a & 0xFF0000) >> 16;
        int ag = (a & 0xFF00) >> 8;
        int ab = a & 0xFF;
        int br = (b & 0xFF0000) >> 16;
        int bg = (b & 0xFF00) >> 8;
        int bb = b & 0xFF;
        int mr = (int)Math.min(255.0, Math.max(0.0, Math.floor((double)ar * (1.0 - mix) + (double)br * mix)));
        int mg = (int)Math.min(255.0, Math.max(0.0, Math.floor((double)ag * (1.0 - mix) + (double)bg * mix)));
        int mb = (int)Math.min(255.0, Math.max(0.0, Math.floor((double)ab * (1.0 - mix) + (double)bb * mix)));
        return mr << 16 | mg << 8 | mb | 0xFF000000;
    }

    public static int brightness(int col, double light) {
        int r = (col & 0xFF0000) >> 16;
        int g = (col & 0xFF00) >> 8;
        int b = col & 0xFF;
        r = (int)Math.min(255.0, Math.floor((double)r * light));
        g = (int)Math.min(255.0, Math.floor((double)g * light));
        b = (int)Math.min(255.0, Math.floor((double)b * light));
        return r << 16 | g << 8 | b | 0xFF000000;
    }

    public static int temptint(int col, double temp) {
        int r = (col & 0xFF0000) >> 16;
        int g = (col & 0xFF00) >> 8;
        int b = col & 0xFF;
        double limit = 0.25;
        double factor = Math.max(-limit, Math.min(limit, (temp - 0.4) * 0.75));
        r = (int)Math.min(255.0, Math.floor((double)r * (1.0 + factor)));
        g = (int)Math.min(255.0, Math.floor((double)g * (1.0 + factor * 0.5)));
        b = (int)Math.min(255.0, Math.floor((double)b * (1.0 - factor * 2.5)));
        return r << 16 | g << 8 | b | 0xFF000000;
    }
}

