/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BOPBlocks;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class BlockFoliageBOP
extends BlockBush
implements IPlantable {
    protected static final VoxelShape NORMAL = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    protected static final VoxelShape SHORT = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);

    public BlockFoliageBOP(Block.Properties properties) {
        super(properties);
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block == BOPBlocks.desert_grass) {
            return SHORT;
        }
        return NORMAL;
    }

    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return Items.field_190931_a;
    }

    public int func_196251_a(IBlockState state, int fortune, World worldIn, BlockPos pos, Random random) {
        return 1 + random.nextInt(fortune * 2 + 1);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(StatList.field_188065_ae.func_199076_b((Object)this));
            player.func_71020_j(0.005f);
            BlockFoliageBOP.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)this));
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public List<ItemStack> onSheared(ItemStack item, IWorld world, BlockPos pos, int fortune) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
        return Arrays.asList(new ItemStack((IItemProvider)this));
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        Block block = state.func_177230_c();
        if (block == BOPBlocks.barley) {
            if (world.field_73012_v.nextInt(8) != 0) {
                return;
            }
            ItemStack seed = ForgeHooks.getGrassSeed((Random)world.field_73012_v, (int)fortune);
            if (!seed.func_190926_b()) {
                drops.add((Object)seed);
            }
        }
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        Block ground = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (this == BOPBlocks.dune_grass) {
            return ground == Blocks.field_150354_m || ground == Blocks.field_196611_F || ground == BOPBlocks.white_sand;
        }
        if (this == BOPBlocks.desert_grass || this == BOPBlocks.dead_grass) {
            return ground == BOPBlocks.dried_sand || ground == Blocks.field_150351_n || ground == Blocks.field_150354_m || ground == Blocks.field_196611_F || ground == BOPBlocks.white_sand || super.func_196260_a(state, worldIn, pos);
        }
        return super.func_196260_a(state, worldIn, pos);
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XYZ;
    }

    public EnumPlantType getPlantType(IBlockReader world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public int getFlammability(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing face) {
        return Blocks.field_150349_c.getFlammability(state, world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing face) {
        return Blocks.field_150349_c.getFireSpreadSpeed(state, world, pos, face);
    }
}

