/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.command;

import com.google.common.collect.Streams;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.biome.Biome;

public class BiomeArgument
implements ArgumentType<Biome> {
    private static final Collection<String> EXAMPLES = Streams.stream((Iterable)IRegistry.field_212624_m).map(biome -> IRegistry.field_212624_m.func_177774_c((Object)((Biome)biome)).toString()).collect(Collectors.toList());
    public static final DynamicCommandExceptionType INVALID_BIOME_EXCEPTION = new DynamicCommandExceptionType(biome -> new TextComponentTranslation("argument.biomesoplenty.biome.invalid", new Object[]{biome}));

    public <S> Biome parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation location = ResourceLocation.func_195826_a((StringReader)reader);
        Biome biome = (Biome)IRegistry.field_212624_m.func_212608_b(location);
        if (biome == null) {
            throw INVALID_BIOME_EXCEPTION.create((Object)location);
        }
        return biome;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder suggestionsBuilder) {
        return ISuggestionProvider.func_212476_a(Streams.stream((Iterable)IRegistry.field_212624_m).map(biome -> IRegistry.field_212624_m.func_177774_c((Object)((Biome)biome))), (SuggestionsBuilder)suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static BiomeArgument createArgument() {
        return new BiomeArgument();
    }

    public static Biome getValue(CommandContext<CommandSource> context, String name) {
        return (Biome)context.getArgument(name, Biome.class);
    }
}

