/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.common.world.BOPLayerUtil;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.OverworldBiomeProviderSettings;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.storage.WorldInfo;

public class BOPBiomeProvider
extends BiomeProvider {
    private final BiomeCache cache = new BiomeCache((BiomeProvider)this);
    private final GenLayer genBiomes;
    private final GenLayer biomeFactoryLayer;
    private final Biome[] biomes = new Biome[]{Biomes.field_76771_b, Biomes.field_76772_c, Biomes.field_76769_d, Biomes.field_76770_e, Biomes.field_76767_f, Biomes.field_76768_g, Biomes.field_76780_h, Biomes.field_76781_i, Biomes.field_76776_l, Biomes.field_76777_m, Biomes.field_76774_n, Biomes.field_76775_o, Biomes.field_76789_p, Biomes.field_76788_q, Biomes.field_76787_r, Biomes.field_76786_s, Biomes.field_76785_t, Biomes.field_76784_u, Biomes.field_76783_v, Biomes.field_76782_w, Biomes.field_76792_x, Biomes.field_150574_L, Biomes.field_150575_M, Biomes.field_150576_N, Biomes.field_150577_O, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_150585_R, Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_150578_U, Biomes.field_150581_V, Biomes.field_150580_W, Biomes.field_150588_X, Biomes.field_150587_Y, Biomes.field_150589_Z, Biomes.field_150607_aa, Biomes.field_150608_ab, Biomes.field_203614_T, Biomes.field_203615_U, Biomes.field_203616_V, Biomes.field_203617_W, Biomes.field_203618_X, Biomes.field_203619_Y, Biomes.field_203620_Z, Biomes.field_185441_Q, Biomes.field_185442_R, Biomes.field_185443_S, Biomes.field_185444_T, Biomes.field_150590_f, Biomes.field_150599_m, Biomes.field_185445_W, Biomes.field_185446_X, Biomes.field_185447_Y, Biomes.field_185448_Z, Biomes.field_185429_aa, Biomes.field_185430_ab, Biomes.field_185431_ac, Biomes.field_185432_ad, Biomes.field_185433_ae, Biomes.field_185434_af, Biomes.field_185435_ag, Biomes.field_185436_ah, Biomes.field_185437_ai, Biomes.field_185438_aj, Biomes.field_185439_ak};

    public BOPBiomeProvider(OverworldBiomeProviderSettings settingsProvider) {
        WorldInfo worldinfo = settingsProvider.func_205440_a();
        OverworldGenSettings settings = settingsProvider.func_205442_b();
        GenLayer[] agenlayer = BOPLayerUtil.createGenLayers(worldinfo.func_76063_b(), worldinfo.func_76067_t(), settings);
        this.genBiomes = agenlayer[0];
        this.biomeFactoryLayer = agenlayer[1];
    }

    @Nullable
    public Biome func_180300_a(BlockPos pos, @Nullable Biome defaultBiome) {
        return this.cache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), defaultBiome);
    }

    public Biome[] func_201535_a(int startX, int startZ, int xSize, int zSize) {
        return this.genBiomes.func_202833_a(startX, startZ, xSize, zSize, Biomes.field_180279_ad);
    }

    public Biome[] func_201537_a(int x, int z, int width, int length, boolean cacheFlag) {
        return cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0 ? this.cache.func_76839_e(x, z) : this.biomeFactoryLayer.func_202833_a(x, z, width, length, Biomes.field_180279_ad);
    }

    public Set<Biome> func_201538_a(int centerX, int centerZ, int sideLength) {
        int i = centerX - sideLength >> 2;
        int j = centerZ - sideLength >> 2;
        int k = centerX + sideLength >> 2;
        int l = centerZ + sideLength >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        HashSet set = Sets.newHashSet();
        Collections.addAll(set, this.genBiomes.func_202833_a(i, j, i1, j1, (Biome)null));
        return set;
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        Biome[] abiome = this.genBiomes.func_202833_a(i, j, i1, j1, (Biome)null);
        BlockPos blockpos = null;
        int k1 = 0;
        for (int l1 = 0; l1 < i1 * j1; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            if (!biomes.contains(abiome[l1])) continue;
            if (blockpos == null || random.nextInt(k1 + 1) == 0) {
                blockpos = new BlockPos(i2, 0, j2);
            }
            ++k1;
        }
        return blockpos;
    }

    public boolean func_205004_a(Structure<?> structureIn) {
        return this.field_205005_a.computeIfAbsent(structureIn, p_205006_1_ -> {
            for (Biome biome : this.biomes) {
                if (!biome.func_201858_a(p_205006_1_)) continue;
                return true;
            }
            return false;
        });
    }

    public Set<IBlockState> func_205706_b() {
        if (this.field_205707_b.isEmpty()) {
            for (Biome biome : this.biomes) {
                this.field_205707_b.add(biome.func_203944_q().func_204108_a());
            }
        }
        return this.field_205707_b;
    }

    public void func_73660_a() {
        this.cache.func_76838_a();
    }
}

