/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.layer.GenLayerBiomeBOP;
import biomesoplenty.common.world.layer.GenLayerBiomeEdgeBOP;
import biomesoplenty.common.world.layer.GenLayerClimate;
import biomesoplenty.common.world.layer.GenLayerLargeIsland;
import biomesoplenty.common.world.layer.GenLayerMixOceansBOP;
import biomesoplenty.common.world.layer.GenLayerRainfallNoise;
import biomesoplenty.common.world.layer.GenLayerRainfallRandom;
import biomesoplenty.common.world.layer.GenLayerRiverMixBOP;
import biomesoplenty.common.world.layer.GenLayerShoreBOP;
import biomesoplenty.common.world.layer.GenLayerSubBiome;
import biomesoplenty.common.world.layer.GenLayerTemperatureLatitude;
import biomesoplenty.common.world.layer.GenLayerTemperatureNoise;
import biomesoplenty.common.world.layer.GenLayerTemperatureRandom;
import biomesoplenty.common.world.layer.traits.LazyAreaLayerContextBOP;
import com.google.common.collect.ImmutableList;
import java.util.function.LongFunction;
import net.minecraft.init.Biomes;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.IContextExtended;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerAddIsland;
import net.minecraft.world.gen.layer.GenLayerAddMushroomIsland;
import net.minecraft.world.gen.layer.GenLayerDeepOcean;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerRareBiome;
import net.minecraft.world.gen.layer.GenLayerRemoveTooMuchOcean;
import net.minecraft.world.gen.layer.GenLayerRiver;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.OceanLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;

public class BOPLayerUtil {
    public static final int WARM_OCEAN = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_203614_T);
    public static final int LUKEWARM_OCEAN = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_203615_U);
    public static final int OCEAN = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76771_b);
    public static final int COLD_OCEAN = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_203616_V);
    public static final int FROZEN_OCEAN = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76776_l);
    public static final int DEEP_WARM_OCEAN = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_203617_W);
    public static final int DEEP_LUKEWARM_OCEAN = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_203618_X);
    public static final int DEEP_OCEAN = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_150575_M);
    public static final int DEEP_COLD_OCEAN = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_203619_Y);
    public static final int DEEP_FROZEN_OCEAN = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_203620_Z);

    public static <T extends IArea, C extends IContextExtended<T>> IAreaFactory<T> createInitialLandAndSeaFactory(LongFunction<C> contextFactory) {
        IAreaFactory factory = GenLayerIsland.INSTANCE.func_202823_a((IContextExtended)contextFactory.apply(1L));
        factory = GenLayerZoom.FUZZY.func_202713_a((IContextExtended)contextFactory.apply(2000L), factory);
        factory = GenLayerAddIsland.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(1L), factory);
        factory = GenLayerZoom.NORMAL.func_202713_a((IContextExtended)contextFactory.apply(2001L), factory);
        factory = GenLayerAddIsland.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(2L), factory);
        factory = GenLayerAddIsland.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(50L), factory);
        factory = GenLayerAddIsland.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(70L), factory);
        factory = GenLayerRemoveTooMuchOcean.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(2L), factory);
        factory = GenLayerAddIsland.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(3L), factory);
        factory = GenLayerZoom.NORMAL.func_202713_a((IContextExtended)contextFactory.apply(2002L), factory);
        factory = GenLayerZoom.NORMAL.func_202713_a((IContextExtended)contextFactory.apply(2003L), factory);
        factory = GenLayerAddIsland.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(4L), factory);
        return factory;
    }

    public static <T extends IArea, C extends IContextExtended<T>> IAreaFactory<T> createClimateFactory(LongFunction<C> contextFactory, BOPWorldSettings settings) {
        IAreaFactory rainfallFactory;
        IAreaFactory temperatureFactory;
        switch (settings.tempScheme) {
            default: {
                temperatureFactory = GenLayerTemperatureLatitude.INSTANCE.apply((IContextExtended)contextFactory.apply(2L));
                break;
            }
            case SMALL_ZONES: {
                temperatureFactory = GenLayerTemperatureNoise.SMALL_ZONES.apply((IContextExtended)contextFactory.apply(3L));
                break;
            }
            case MEDIUM_ZONES: {
                temperatureFactory = GenLayerTemperatureNoise.MEDIUM_ZONES.apply((IContextExtended)contextFactory.apply(4L));
                break;
            }
            case LARGE_ZONES: {
                temperatureFactory = GenLayerTemperatureNoise.LARGE_ZONES.apply((IContextExtended)contextFactory.apply(5L));
                break;
            }
            case RANDOM: {
                temperatureFactory = GenLayerTemperatureRandom.INSTANCE.apply((IContextExtended)contextFactory.apply(6L));
            }
        }
        switch (settings.rainScheme) {
            case SMALL_ZONES: {
                rainfallFactory = GenLayerRainfallNoise.SMALL_ZONES.apply((IContextExtended)contextFactory.apply(7L));
                break;
            }
            default: {
                rainfallFactory = GenLayerRainfallNoise.MEDIUM_ZONES.apply((IContextExtended)contextFactory.apply(8L));
                break;
            }
            case LARGE_ZONES: {
                rainfallFactory = GenLayerRainfallNoise.LARGE_ZONES.apply((IContextExtended)contextFactory.apply(9L));
                break;
            }
            case RANDOM: {
                rainfallFactory = GenLayerRainfallRandom.INSTANCE.apply((IContextExtended)contextFactory.apply(10L));
            }
        }
        return GenLayerClimate.INSTANCE.func_202707_a((IContextExtended)contextFactory.apply(103L), temperatureFactory, rainfallFactory);
    }

    public static <T extends IArea, C extends IContextExtended<T>> IAreaFactory<T> createBiomeFactory(IAreaFactory<T> landSeaAreaFactory, IAreaFactory<T> climateAreaFactory, LongFunction<C> contextFactory) {
        IAreaFactory biomeFactory = GenLayerBiomeBOP.INSTANCE.func_202707_a((IContextExtended)contextFactory.apply(200L), landSeaAreaFactory, climateAreaFactory);
        biomeFactory = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)GenLayerZoom.NORMAL, (IAreaFactory)biomeFactory, (int)2, contextFactory);
        biomeFactory = GenLayerBiomeEdgeBOP.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(1000L), biomeFactory);
        return biomeFactory;
    }

    public static <T extends IArea, C extends IContextExtended<T>> ImmutableList<IAreaFactory<T>> createAreaFactories(WorldType worldType, OverworldGenSettings settings, LongFunction<C> contextFactory) {
        int biomeSize;
        IAreaFactory landSeaFactory = BOPLayerUtil.createInitialLandAndSeaFactory(contextFactory);
        IAreaFactory oceanBiomeFactory = OceanLayer.INSTANCE.func_202823_a((IContextExtended)contextFactory.apply(2L));
        oceanBiomeFactory = LayerUtil.func_202829_a((long)2001L, (IAreaTransformer1)GenLayerZoom.NORMAL, (IAreaFactory)oceanBiomeFactory, (int)6, contextFactory);
        int riverSize = biomeSize = 4;
        if (settings != null) {
            biomeSize = settings.func_202200_j();
            riverSize = settings.func_202198_k();
        }
        biomeSize = LayerUtil.getModdedBiomeSize((WorldType)worldType, (int)biomeSize);
        IAreaFactory climateFactory = BOPLayerUtil.createClimateFactory(contextFactory, new BOPWorldSettings());
        landSeaFactory = GenLayerAddMushroomIsland.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(5L), landSeaFactory);
        landSeaFactory = GenLayerLargeIsland.INSTANCE.func_202707_a((IContextExtended)contextFactory.apply(5L), landSeaFactory, climateFactory);
        landSeaFactory = GenLayerDeepOcean.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(4L), landSeaFactory);
        IAreaFactory biomesFactory = BOPLayerUtil.createBiomeFactory(landSeaFactory, climateFactory, contextFactory);
        IAreaFactory riverAndSubBiomesInitFactory = GenLayerRiverInit.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(100L), landSeaFactory);
        riverAndSubBiomesInitFactory = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)GenLayerZoom.NORMAL, (IAreaFactory)riverAndSubBiomesInitFactory, (int)2, contextFactory);
        biomesFactory = GenLayerSubBiome.INSTANCE.func_202707_a((IContextExtended)contextFactory.apply(1000L), biomesFactory, riverAndSubBiomesInitFactory);
        IAreaFactory riversInitFactory = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)GenLayerZoom.NORMAL, (IAreaFactory)riverAndSubBiomesInitFactory, (int)riverSize, contextFactory);
        riversInitFactory = GenLayerRiver.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(1L), riversInitFactory);
        riversInitFactory = GenLayerSmooth.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(1000L), riversInitFactory);
        biomesFactory = GenLayerRareBiome.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(1001L), biomesFactory);
        for (int i = 0; i < biomeSize; ++i) {
            biomesFactory = GenLayerZoom.NORMAL.func_202713_a((IContextExtended)contextFactory.apply(1000 + i), biomesFactory);
            if (i == 0) {
                biomesFactory = GenLayerAddIsland.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(3L), biomesFactory);
            }
            if (i != 1 && biomeSize != 1) continue;
            biomesFactory = GenLayerShoreBOP.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(1000L), biomesFactory);
        }
        biomesFactory = GenLayerSmooth.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(1000L), biomesFactory);
        biomesFactory = GenLayerRiverMixBOP.INSTANCE.func_202707_a((IContextExtended)contextFactory.apply(100L), biomesFactory, riversInitFactory);
        climateFactory = LayerUtil.func_202829_a((long)2001L, (IAreaTransformer1)GenLayerZoom.NORMAL, climateFactory, (int)6, contextFactory);
        biomesFactory = GenLayerMixOceansBOP.INSTANCE.apply((IContextExtended)contextFactory.apply(100L), biomesFactory, oceanBiomeFactory, climateFactory);
        IAreaFactory voroniZoomBiomesFactory = GenLayerVoronoiZoom.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(10L), biomesFactory);
        return ImmutableList.of(biomesFactory, (Object)voroniZoomBiomesFactory, biomesFactory);
    }

    public static GenLayer[] createGenLayers(long seed, WorldType worldType, OverworldGenSettings settings) {
        int[] layerCount = new int[1];
        ImmutableList factoryList = BOPLayerUtil.createAreaFactories(worldType, settings, seedModifier -> {
            layerCount[0] = layerCount[0] + 1;
            return new LazyAreaLayerContextBOP(1, layerCount[0], seed, seedModifier);
        });
        GenLayer biomesLayer = new GenLayer((IAreaFactory)factoryList.get(0));
        GenLayer voroniZoomBiomesLayer = new GenLayer((IAreaFactory)factoryList.get(1));
        GenLayer biomesLayer2 = new GenLayer((IAreaFactory)factoryList.get(2));
        return new GenLayer[]{biomesLayer, voroniZoomBiomesLayer, biomesLayer2};
    }

    public static boolean isOcean(int biomeIn) {
        return biomeIn == WARM_OCEAN || biomeIn == LUKEWARM_OCEAN || biomeIn == OCEAN || biomeIn == COLD_OCEAN || biomeIn == FROZEN_OCEAN || biomeIn == DEEP_WARM_OCEAN || biomeIn == DEEP_LUKEWARM_OCEAN || biomeIn == DEEP_OCEAN || biomeIn == DEEP_COLD_OCEAN || biomeIn == DEEP_FROZEN_OCEAN;
    }

    public static boolean isShallowOcean(int biomeIn) {
        return biomeIn == WARM_OCEAN || biomeIn == LUKEWARM_OCEAN || biomeIn == OCEAN || biomeIn == COLD_OCEAN || biomeIn == FROZEN_OCEAN;
    }
}

