/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.IPlantable;

public class BigTreeFeature
extends TreeFeatureBase {
    private Random random;
    private IWorld world;
    private BlockPos origin;
    private int height;
    private int trunkHeight;
    private double trunkHeightScale = 0.618;
    private double branchSlope = 0.381;
    private double widthScale = 1.0;
    private int trunkWidth = 1;
    private boolean updateNeighbours;
    private int foliageHeight;
    private double foliageDensity;
    private List<FoliageCoords> foliageCoords;

    protected BigTreeFeature(boolean notify, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState altLeaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, int minHeight, int maxHeight, int trunkWidth, int foliageHeight, double foliageDensity) {
        super(notify, placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
        this.foliageHeight = foliageHeight;
        this.foliageDensity = foliageDensity;
        this.trunkWidth = trunkWidth;
    }

    protected void prepare() {
        int relativeY;
        int clustersPerY;
        this.trunkHeight = (int)((double)this.height * this.trunkHeightScale);
        if (this.trunkHeight >= this.height) {
            this.trunkHeight = this.height - 1;
        }
        if ((clustersPerY = (int)(1.382 + Math.pow(this.foliageDensity * (double)this.height / 13.0, 2.0))) < 1) {
            clustersPerY = 1;
        }
        int trunkTop = this.origin.func_177956_o() + this.trunkHeight;
        this.foliageCoords = Lists.newArrayList();
        this.foliageCoords.add(new FoliageCoords(this.origin.func_177981_b(relativeY), trunkTop));
        for (relativeY = this.height - this.foliageHeight; relativeY >= 0; --relativeY) {
            float treeShape = this.treeShape(relativeY);
            if (treeShape < 0.0f) continue;
            for (int i = 0; i < clustersPerY; ++i) {
                BlockPos checkEnd;
                double z;
                double angle;
                double radius = this.widthScale * (double)treeShape * ((double)this.random.nextFloat() + 0.328);
                double x = radius * Math.sin(angle = (double)(this.random.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos checkStart = this.origin.func_177963_a(x, (double)(relativeY - 1), z = radius * Math.cos(angle) + 0.5);
                if (this.checkLine(checkStart, checkEnd = checkStart.func_177981_b(this.foliageHeight)) != -1) continue;
                int dx = this.origin.func_177958_n() - checkStart.func_177958_n();
                int dz = this.origin.func_177952_p() - checkStart.func_177952_p();
                double height = (double)checkStart.func_177956_o() - Math.sqrt(dx * dx + dz * dz) * this.branchSlope;
                int branchTop = height > (double)trunkTop ? trunkTop : (int)height;
                BlockPos checkBranchBase = new BlockPos(this.origin.func_177958_n(), branchTop, this.origin.func_177952_p());
                if (this.checkLine(checkBranchBase, checkStart) != -1) continue;
                this.foliageCoords.add(new FoliageCoords(checkStart, checkBranchBase.func_177956_o()));
            }
        }
    }

    private void crossection(BlockPos pos, float radius) {
        int r = (int)((double)radius + 0.618);
        for (int dx = -r; dx <= r; ++dx) {
            for (int dz = -r; dz <= r; ++dz) {
                BlockPos checkedPos;
                if (!(Math.pow((double)Math.abs(dx) + 0.5, 2.0) + Math.pow((double)Math.abs(dz) + 0.5, 2.0) <= (double)(radius * radius)) || !this.replace.matches(this.world, checkedPos = pos.func_177982_a(dx, 0, dz))) continue;
                if (this.altLeaves != Blocks.field_150350_a.func_176223_P()) {
                    int rand = new Random().nextInt(4);
                    if (rand == 0) {
                        this.setAltLeaves(this.world, checkedPos);
                        continue;
                    }
                    this.setLeaves(this.world, checkedPos);
                    continue;
                }
                this.setLeaves(this.world, checkedPos);
            }
        }
    }

    protected float treeShape(int y) {
        if ((float)y < (float)this.height * 0.3f) {
            return -1.0f;
        }
        float radius = (float)this.height / 2.0f;
        float adjacent = radius - (float)y;
        float distance = MathHelper.func_76129_c((float)(radius * radius - adjacent * adjacent));
        if (adjacent == 0.0f) {
            distance = radius;
        } else if (Math.abs(adjacent) >= radius) {
            return 0.0f;
        }
        return distance * 0.5f;
    }

    protected float foliageShape(int y) {
        if (y < 0 || y >= this.foliageHeight) {
            return -1.0f;
        }
        if (y == 0 || y == this.foliageHeight - 1) {
            return 2.0f;
        }
        return 3.0f;
    }

    private void foliageCluster(BlockPos blockPos) {
        for (int y = 0; y < this.foliageHeight; ++y) {
            this.crossection(blockPos.func_177981_b(y), this.foliageShape(y));
        }
    }

    private void limb(Set<BlockPos> changedBlocks, BlockPos startPos, BlockPos endPos, IBlockState state) {
        BlockPos delta = endPos.func_177982_a(-startPos.func_177958_n(), -startPos.func_177956_o(), -startPos.func_177952_p());
        int steps = this.getSteps(delta);
        float dx = (float)delta.func_177958_n() / (float)steps;
        float dy = (float)delta.func_177956_o() / (float)steps;
        float dz = (float)delta.func_177952_p() / (float)steps;
        for (int i = 0; i <= steps; ++i) {
            BlockPos blockPos = startPos.func_177963_a((double)(0.5f + (float)i * dx), (double)(0.5f + (float)i * dy), (double)(0.5f + (float)i * dz));
            EnumFacing.Axis logAxis = this.getLogAxis(startPos, blockPos);
            this.setLog(changedBlocks, this.world, blockPos, logAxis);
        }
    }

    private int getSteps(BlockPos pos) {
        int absX = MathHelper.func_76130_a((int)pos.func_177958_n());
        int absY = MathHelper.func_76130_a((int)pos.func_177956_o());
        int absZ = MathHelper.func_76130_a((int)pos.func_177952_p());
        if (absZ > absX && absZ > absY) {
            return absZ;
        }
        if (absY > absX) {
            return absY;
        }
        return absX;
    }

    private int getGreatestDistance(BlockPos posIn) {
        int i = MathHelper.func_76130_a((int)posIn.func_177958_n());
        int j = MathHelper.func_76130_a((int)posIn.func_177956_o());
        int k = MathHelper.func_76130_a((int)posIn.func_177952_p());
        return k > i && k > j ? k : (j > i ? j : i);
    }

    private EnumFacing.Axis getLogAxis(BlockPos startPos, BlockPos endPos) {
        int zDiff;
        EnumFacing.Axis axis = EnumFacing.Axis.Y;
        int xDiff = Math.abs(endPos.func_177958_n() - startPos.func_177958_n());
        int maxDiff = Math.max(xDiff, zDiff = Math.abs(endPos.func_177952_p() - startPos.func_177952_p()));
        if (maxDiff > 0) {
            if (xDiff == maxDiff) {
                axis = EnumFacing.Axis.X;
            } else if (zDiff == maxDiff) {
                axis = EnumFacing.Axis.Z;
            }
        }
        return axis;
    }

    private void makeFoliage() {
        for (FoliageCoords foliageCoord : this.foliageCoords) {
            this.foliageCluster(foliageCoord);
        }
    }

    protected boolean trimBranches(int localY) {
        return (double)localY >= (double)this.height * 0.2;
    }

    private void makeTrunk(Set<BlockPos> changedBlocks) {
        BlockPos start = this.origin;
        BlockPos end = this.origin.func_177981_b(this.trunkHeight);
        IBlockState materialState = this.log;
        this.limb(changedBlocks, start, end, materialState);
        if (this.trunkWidth == 2) {
            this.limb(changedBlocks, start.func_177974_f(), end.func_177974_f(), materialState);
            this.limb(changedBlocks, start.func_177974_f().func_177968_d(), end.func_177974_f().func_177968_d(), materialState);
            this.limb(changedBlocks, start.func_177968_d(), end.func_177968_d(), materialState);
        }
    }

    private void makeBranches(Set<BlockPos> changedBlocks) {
        for (FoliageCoords endCoord : this.foliageCoords) {
            int branchBase = endCoord.getBranchBase();
            BlockPos baseCoord = new BlockPos(this.origin.func_177958_n(), branchBase, this.origin.func_177952_p());
            if (!this.trimBranches(branchBase - this.origin.func_177956_o())) continue;
            this.limb(changedBlocks, baseCoord, endCoord, this.log);
        }
    }

    private int checkLine(BlockPos startPos, BlockPos endPos) {
        BlockPos delta = endPos.func_177982_a(-startPos.func_177958_n(), -startPos.func_177956_o(), -startPos.func_177952_p());
        int steps = this.getGreatestDistance(delta);
        float dx = (float)delta.func_177958_n() / (float)steps;
        float dy = (float)delta.func_177956_o() / (float)steps;
        float dz = (float)delta.func_177952_p() / (float)steps;
        if (steps == 0) {
            return -1;
        }
        for (int i = 0; i <= steps; ++i) {
            BlockPos deltaPos = startPos.func_177963_a((double)(0.5f + (float)i * dx), (double)(0.5f + (float)i * dy), (double)(0.5f + (float)i * dz));
            if (this.replace.matches(this.world, deltaPos)) continue;
            return i;
        }
        return -1;
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorld world, Random random, BlockPos startPos) {
        this.world = world;
        this.origin = startPos;
        this.random = new Random(random.nextLong());
        this.height = random.nextInt(this.maxHeight - this.minHeight) + this.minHeight;
        if (!this.checkLocation()) {
            this.world = null;
            return false;
        }
        try {
            this.prepare();
            this.makeFoliage();
            this.makeTrunk(changedBlocks);
            this.makeBranches(changedBlocks);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.world = null;
        return true;
    }

    private boolean checkLocation() {
        BlockPos down = this.origin.func_177977_b();
        IBlockState state = this.world.func_180495_p(down);
        boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockReader)this.world, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_196674_t));
        if (!isSoil && !this.placeOn.matches(this.world, down)) {
            return false;
        }
        int allowedHeight = this.checkLine(this.origin, this.origin.func_177981_b(this.height - 1));
        if (this.trunkWidth == 2) {
            allowedHeight = Math.min(this.checkLine(this.origin.func_177974_f(), this.origin.func_177974_f().func_177981_b(this.height - 1)), allowedHeight);
            allowedHeight = Math.min(this.checkLine(this.origin.func_177974_f().func_177968_d(), this.origin.func_177974_f().func_177968_d().func_177981_b(this.height - 1)), allowedHeight);
            allowedHeight = Math.min(this.checkLine(this.origin.func_177968_d(), this.origin.func_177968_d().func_177981_b(this.height - 1)), allowedHeight);
        }
        if (allowedHeight == -1) {
            return true;
        }
        if (allowedHeight < this.minHeight) {
            return false;
        }
        this.height = allowedHeight;
        return true;
    }

    private static class FoliageCoords
    extends BlockPos {
        private final int branchBase;

        public FoliageCoords(BlockPos pos, int branchBase) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.branchBase = branchBase;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, BigTreeFeature> {
        private int trunkWidth;
        private int foliageHeight;
        private double foliageDensity;

        public Builder trunkWidth(int a) {
            this.trunkWidth = a;
            return this;
        }

        public Builder foliageHeight(int a) {
            this.foliageHeight = a;
            return this;
        }

        public Builder foliageDensity(int a) {
            this.foliageDensity = a;
            return this;
        }

        public Builder() {
            this.minHeight = 5;
            this.maxHeight = 17;
            this.trunkWidth = 1;
            this.foliageHeight = 4;
            this.foliageDensity = 1.0;
        }

        @Override
        public BigTreeFeature create() {
            return new BigTreeFeature(this.updateNeighbours, this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight, this.trunkWidth, this.foliageHeight, this.foliageDensity);
        }
    }
}

