/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class BushTreeFeature
extends TreeFeatureBase {
    protected BushTreeFeature(boolean notify, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState altLeaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, int minHeight, int maxHeight) {
        super(notify, placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorld world, Random random, BlockPos startPos) {
        while (startPos.func_177956_o() > 1 && world.func_175623_d(startPos) || world.func_180495_p(startPos).func_185904_a() == Material.field_151579_a) {
            startPos = startPos.func_177977_b();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = GeneratorUtil.nextIntBetween(random, this.minHeight, this.maxHeight);
        BlockPos pos = startPos.func_177984_a();
        for (int y = 0; y < height; ++y) {
            if (height - y > 1) {
                this.setLog(changedBlocks, world, pos.func_177982_a(0, y, 0));
            }
            int leavesRadius = height - y > 1 ? 2 : 1;
            for (int x = -leavesRadius; x <= leavesRadius; ++x) {
                for (int z = -leavesRadius; z <= leavesRadius; ++z) {
                    if (Math.abs(x) >= leavesRadius && Math.abs(z) >= leavesRadius && random.nextInt(2) == 0) continue;
                    if (this.altLeaves != Blocks.field_150350_a.func_176223_P()) {
                        if (random.nextInt(4) == 0) {
                            this.setAltLeaves(world, pos.func_177982_a(x, y, z));
                            continue;
                        }
                        this.setLeaves(world, pos.func_177982_a(x, y, z));
                        continue;
                    }
                    this.setLeaves(world, pos.func_177982_a(x, y, z));
                }
            }
        }
        return true;
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, BushTreeFeature> {
        public Builder() {
            this.minHeight = 2;
            this.maxHeight = 4;
        }

        @Override
        public BushTreeFeature create() {
            if (this.leaves != Blocks.field_150350_a.func_176223_P()) {
                this.leaves = this.leaves;
            }
            if (this.altLeaves != Blocks.field_150350_a.func_176223_P()) {
                this.altLeaves = this.altLeaves;
            }
            return new BushTreeFeature(this.updateNeighbours, this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight);
        }
    }
}

