/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class PalmTreeFeature
extends TreeFeatureBase {
    protected PalmTreeFeature(boolean notify, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState altLeaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, int minHeight, int maxHeight) {
        super(notify, placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorld world, Random random, BlockPos startPos) {
        while (startPos.func_177956_o() > 1 && world.func_175623_d(startPos) || world.func_180495_p(startPos).func_185904_a() == Material.field_151584_j) {
            startPos = startPos.func_177977_b();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = GeneratorUtil.nextIntBetween(random, this.minHeight, this.maxHeight);
        int leavesRadius = 2;
        int heightMinusTop = height - leavesRadius - 1;
        boolean slant = false;
        EnumFacing direction = EnumFacing.func_176741_a((Random)random);
        if (direction == EnumFacing.DOWN || direction == EnumFacing.UP) {
            slant = false;
        }
        double baseSlant = (double)random.nextInt(35) / 100.0;
        double slantMultiplier = 1.3;
        if (height < 8) {
            return false;
        }
        BlockPos pos = startPos.func_177984_a();
        if (!this.checkSpace(world, pos, height, 1)) {
            return false;
        }
        double slantOffset = baseSlant;
        for (int step = 0; step <= heightMinusTop; ++step) {
            BlockPos offsetPos = pos.func_177981_b(step);
            if (slant) {
                offsetPos = pos.func_177981_b(step).func_177967_a(direction, (int)Math.floor(slantOffset));
            }
            if (step == heightMinusTop) {
                this.setLog(changedBlocks, world, offsetPos);
                this.generateLeavesTop(world, offsetPos, leavesRadius);
                break;
            }
            this.setLog(changedBlocks, world, offsetPos);
            slantOffset *= slantMultiplier;
        }
        return true;
    }

    public boolean checkSpace(IWorld world, BlockPos pos, int height, int radius) {
        for (int y = 0; y <= height; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeavesTop(IWorld world, BlockPos pos, int maxRadius) {
        this.setLeaves(world, pos.func_177982_a(2, -1, 0));
        this.setLeaves(world, pos.func_177982_a(-2, -1, 0));
        this.setLeaves(world, pos.func_177982_a(0, -1, 2));
        this.setLeaves(world, pos.func_177982_a(0, -1, -2));
        this.setLeaves(world, pos.func_177982_a(1, 0, 0));
        this.setLeaves(world, pos.func_177982_a(-1, 0, 0));
        this.setLeaves(world, pos.func_177982_a(0, 0, 1));
        this.setLeaves(world, pos.func_177982_a(0, 0, -1));
        this.setLeaves(world, pos.func_177982_a(2, 0, 2));
        this.setLeaves(world, pos.func_177982_a(-2, 0, -2));
        this.setLeaves(world, pos.func_177982_a(2, 0, -2));
        this.setLeaves(world, pos.func_177982_a(-2, 0, 2));
        this.setLeaves(world, pos.func_177982_a(1, 1, -1));
        this.setLeaves(world, pos.func_177982_a(-1, 1, 1));
        this.setLeaves(world, pos.func_177982_a(1, 1, 1));
        this.setLeaves(world, pos.func_177982_a(-1, 1, -1));
        this.setLeaves(world, pos.func_177982_a(0, 1, 0));
        this.setLeaves(world, pos.func_177982_a(2, 2, 0));
        this.setLeaves(world, pos.func_177982_a(-2, 2, 0));
        this.setLeaves(world, pos.func_177982_a(0, 2, 2));
        this.setLeaves(world, pos.func_177982_a(0, 2, -2));
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, PalmTreeFeature> {
        public Builder() {
            this.minHeight = 10;
            this.maxHeight = 14;
            this.log = BOPBlocks.palm_log.func_176223_P();
            this.leaves = (IBlockState)BOPBlocks.palm_leaves.func_176223_P().func_206870_a((IProperty)BlockLeaves.field_208495_b, (Comparable)Boolean.valueOf(true));
        }

        @Override
        public PalmTreeFeature create() {
            return new PalmTreeFeature(this.updateNeighbours, this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight);
        }
    }
}

