/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;

public class RedwoodTreeFeature
extends TreeFeatureBase {
    private int trunkWidth = 1;

    protected RedwoodTreeFeature(boolean notify, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState altLeaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, int minHeight, int maxHeight, int trunkWidth) {
        super(notify, placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
        this.trunkWidth = trunkWidth;
    }

    public boolean checkSpace(IWorld world, BlockPos pos, int baseHeight, int height) {
        for (int y = 0; y <= height; ++y) {
            int trunkWidth = this.trunkWidth * (height - y) / height + 1;
            int trunkStart = MathHelper.func_76143_f((double)(0.25 - (double)trunkWidth / 2.0));
            int trunkEnd = MathHelper.func_76128_c((double)(0.25 + (double)trunkWidth / 2.0));
            int start = y <= baseHeight ? trunkStart : trunkStart - 1;
            int end = y <= baseHeight ? trunkEnd : trunkEnd + 1;
            for (int x = start; x <= end; ++x) {
                for (int z = start; z <= end; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeafLayer(IWorld world, Random rand, BlockPos pos, int leavesRadius, int trunkStart, int trunkEnd) {
        int start = trunkStart - leavesRadius;
        int end = trunkEnd + leavesRadius;
        for (int x = start; x <= end; ++x) {
            for (int z = start; z <= end; ++z) {
                int distFromTrunk;
                if (leavesRadius > 0 && (x == start || x == end) && (z == start || z == end) || (distFromTrunk = (x < 0 ? trunkStart - x : x - trunkEnd) + (z < 0 ? trunkStart - z : z - trunkEnd)) >= 4 && (distFromTrunk != 4 || rand.nextInt(2) != 0)) continue;
                this.setLeaves(world, pos.func_177982_a(x, 0, z));
            }
        }
    }

    public void generateBranch(Set<BlockPos> changedBlocks, IWorld world, Random rand, BlockPos pos, EnumFacing direction, int length) {
        EnumFacing.Axis axis = direction.func_176740_k();
        EnumFacing sideways = direction.func_176746_e();
        for (int i = 1; i <= length; ++i) {
            BlockPos pos1 = pos.func_177967_a(direction, i);
            int r = i == 1 || i == length ? 1 : 2;
            for (int j = -r; j <= r; ++j) {
                if (i >= length && rand.nextInt(2) != 0) continue;
                this.setLeaves(world, pos1.func_177967_a(sideways, j));
            }
            if (length - i <= 2) continue;
            this.setLeaves(world, pos1.func_177984_a());
            this.setLeaves(world, pos1.func_177984_a().func_177967_a(sideways, -1));
            this.setLeaves(world, pos1.func_177984_a().func_177967_a(sideways, 1));
            this.setLog(changedBlocks, world, pos1, axis);
        }
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorld world, Random random, BlockPos startPos) {
        int trunkEnd;
        int trunkStart;
        int trunkWidth;
        int baseHeight;
        while (startPos.func_177956_o() > 1 && world.func_175623_d(startPos) || world.func_180495_p(startPos).func_185904_a() == Material.field_151584_j) {
            startPos = startPos.func_177977_b();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = GeneratorUtil.nextIntBetween(random, this.minHeight, this.maxHeight);
        int leavesHeight = height - (baseHeight = GeneratorUtil.nextIntBetween(random, (int)((float)height * 0.6f), (int)((float)height * 0.4f)));
        if (leavesHeight < 3) {
            return false;
        }
        if (!this.checkSpace(world, startPos.func_177984_a(), baseHeight, height)) {
            return false;
        }
        BlockPos pos = startPos.func_177981_b(height);
        this.setLeaves(world, pos);
        pos.func_177977_b();
        for (int i = 0; i < leavesHeight; ++i) {
            trunkWidth = this.trunkWidth * i / height + 1;
            trunkStart = MathHelper.func_76143_f((double)(0.25 - (double)trunkWidth / 2.0));
            trunkEnd = MathHelper.func_76128_c((double)(0.25 + (double)trunkWidth / 2.0));
            int radius = Math.min(Math.min((i + 2) / 4, 2 + (leavesHeight - i)), 4);
            if (radius == 0) {
                this.setLeaves(world, pos);
            } else if (radius < 2) {
                this.generateLeafLayer(world, random, pos, radius, trunkStart, trunkEnd);
            } else {
                this.generateBranch(changedBlocks, world, random, pos.func_177982_a(trunkStart, 0, trunkStart), EnumFacing.NORTH, radius);
                this.generateBranch(changedBlocks, world, random, pos.func_177982_a(trunkEnd, 0, trunkStart), EnumFacing.EAST, radius);
                this.generateBranch(changedBlocks, world, random, pos.func_177982_a(trunkEnd, 0, trunkEnd), EnumFacing.SOUTH, radius);
                this.generateBranch(changedBlocks, world, random, pos.func_177982_a(trunkStart, 0, trunkEnd), EnumFacing.WEST, radius);
            }
            pos = pos.func_177977_b();
        }
        for (int y = 0; y < height - 1; ++y) {
            trunkWidth = this.trunkWidth * (height - y) / height + 1;
            trunkStart = MathHelper.func_76143_f((double)(0.25 - (double)trunkWidth / 2.0));
            trunkEnd = MathHelper.func_76128_c((double)(0.25 + (double)trunkWidth / 2.0));
            if (this.trunkWidth <= 1) {
                trunkStart = 0;
                trunkEnd = 0;
            }
            for (int x = trunkStart; x <= trunkEnd; ++x) {
                for (int z = trunkStart; z <= trunkEnd; ++z) {
                    this.setLog(changedBlocks, world, startPos.func_177982_a(x, y, z));
                }
            }
        }
        return true;
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, RedwoodTreeFeature> {
        protected int trunkWidth;

        public Builder trunkWidth(int a) {
            this.trunkWidth = a;
            return this;
        }

        public Builder() {
            this.minHeight = 10;
            this.maxHeight = 30;
            this.log = BOPBlocks.redwood_log.func_176223_P();
            this.leaves = BOPBlocks.redwood_leaves.func_176223_P();
            this.vine = Blocks.field_150395_bd.func_176223_P();
            this.trunkWidth = 1;
        }

        @Override
        public RedwoodTreeFeature create() {
            return new RedwoodTreeFeature(this.updateNeighbours, this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight, this.trunkWidth);
        }
    }
}

