/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.common.util.block.BlockUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public abstract class TreeFeatureBase
extends AbstractTreeFeature<NoFeatureConfig> {
    protected final IBlockPosQuery placeOn;
    protected final IBlockPosQuery replace;
    protected final IBlockState log;
    protected final IBlockState leaves;
    protected final IBlockState altLeaves;
    protected final IBlockState vine;
    protected final IBlockState hanging;
    protected final IBlockState trunkFruit;
    protected final int minHeight;
    protected final int maxHeight;
    protected IProperty logAxisProperty;

    protected TreeFeatureBase(boolean notify, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState altLeaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, int minHeight, int maxHeight) {
        super(notify);
        this.placeOn = placeOn;
        this.replace = replace;
        this.log = log;
        this.leaves = leaves;
        this.logAxisProperty = BlockUtil.getAxisProperty(log);
        this.altLeaves = altLeaves;
        this.vine = vine;
        this.hanging = hanging;
        this.trunkFruit = trunkFruit;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public boolean setLeaves(IWorld world, BlockPos pos) {
        if (this.replace.matches(world, pos)) {
            this.func_202278_a(world, pos, this.leaves);
            return true;
        }
        return false;
    }

    public boolean setLog(Set<BlockPos> changedBlocks, IWorld world, BlockPos pos) {
        return this.setLog(changedBlocks, world, pos, null);
    }

    public boolean setLog(Set<BlockPos> changedBlocks, IWorld world, BlockPos pos, EnumFacing.Axis axis) {
        IBlockState directedLog;
        IBlockState iBlockState = directedLog = axis != null && this.logAxisProperty != null ? (IBlockState)this.log.func_206870_a(this.logAxisProperty, (Comparable)axis) : this.log;
        if (this.replace.matches(world, pos)) {
            this.func_208520_a(changedBlocks, world, pos, directedLog);
            return true;
        }
        return false;
    }

    public boolean setVine(IWorld world, Random rand, BlockPos pos, EnumFacing side, int length) {
        IBlockState vineState = this.vine.func_177230_c() instanceof BlockVine ? (IBlockState)((IBlockState)((IBlockState)((IBlockState)this.vine.func_206870_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(side == EnumFacing.NORTH))).func_206870_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(side == EnumFacing.EAST))).func_206870_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(side == EnumFacing.SOUTH))).func_206870_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(side == EnumFacing.WEST)) : this.vine;
        boolean setOne = false;
        while (world.func_180495_p(pos).func_177230_c().isAir(world.func_180495_p(pos), (IBlockReader)world, pos) && length > 0 && rand.nextInt(12) > 0) {
            this.func_202278_a(world, pos, vineState);
            setOne = true;
            --length;
            pos = pos.func_177977_b();
        }
        return setOne;
    }

    public boolean setHanging(IWorld world, BlockPos pos) {
        if (this.replace.matches(world, pos)) {
            this.func_202278_a(world, pos, this.hanging);
        }
        return false;
    }

    public boolean setTrunkFruit(IWorld world, BlockPos pos) {
        if (this.trunkFruit == null) {
            return false;
        }
        if (this.replace.matches(world, pos)) {
            this.func_202278_a(world, pos, this.trunkFruit);
        }
        return false;
    }

    public boolean setAltLeaves(IWorld world, BlockPos pos) {
        if (this.replace.matches(world, pos)) {
            this.func_202278_a(world, pos, this.altLeaves);
            return true;
        }
        return false;
    }

    protected static abstract class BuilderBase<T extends BuilderBase, F extends TreeFeatureBase> {
        protected IBlockPosQuery placeOn = (world, pos) -> world.func_180495_p(pos).canSustainPlant((IBlockReader)world, pos, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_196674_t));
        protected IBlockPosQuery replace = (world, pos) -> world.func_180495_p(pos).canBeReplacedByLeaves((IWorldReaderBase)world, pos);
        protected IBlockState log = Blocks.field_196617_K.func_176223_P();
        protected IBlockState leaves = Blocks.field_196642_W.func_176223_P();
        protected IBlockState vine = Blocks.field_150350_a.func_176223_P();
        protected IBlockState hanging = Blocks.field_150350_a.func_176223_P();
        protected IBlockState trunkFruit = Blocks.field_150350_a.func_176223_P();
        protected IBlockState altLeaves = Blocks.field_150350_a.func_176223_P();
        protected int minHeight;
        protected int maxHeight;
        protected boolean updateNeighbours = false;

        public T placeOn(IBlockPosQuery a) {
            this.placeOn = a;
            return (T)this;
        }

        public T replace(IBlockPosQuery a) {
            this.replace = a;
            return (T)this;
        }

        public T log(IBlockState a) {
            this.log = a;
            return (T)this;
        }

        public T leaves(IBlockState a) {
            this.leaves = a;
            return (T)this;
        }

        public T vine(IBlockState a) {
            this.vine = a;
            return (T)this;
        }

        public T hanging(IBlockState a) {
            this.hanging = a;
            return (T)this;
        }

        public T trunkFruit(IBlockState a) {
            this.trunkFruit = a;
            return (T)this;
        }

        public T altLeaves(IBlockState a) {
            this.altLeaves = a;
            return (T)this;
        }

        public T minHeight(int a) {
            this.minHeight = a;
            return (T)this;
        }

        public T maxHeight(int a) {
            this.maxHeight = a;
            return (T)this;
        }

        public T updateNeighbours(boolean a) {
            this.updateNeighbours = a;
            return (T)this;
        }

        abstract F create();
    }
}

